/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.junit.Assert;
import org.junit.Test;

public class ActiveMQConcurrentDecompressionTest {
    private volatile AssertionError assertionError;

    @Test
    public void bytesMessageCorruption() throws Exception {
        BrokerService brokerService = new BrokerService();
        brokerService.setBrokerName("embedded");
        brokerService.setPersistent(false);
        brokerService.start();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://embedded");
        connectionFactory.setUseCompression(true);
        Connection connection = connectionFactory.createConnection();
        connection.start();
        for (int i = 0; i < 10; ++i) {
            Session mySession = connection.createSession(false, 1);
            mySession.createConsumer((Destination)mySession.createTopic("foo.bar")).setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    try {
                        Assert.assertEquals((long)1L, (long)((ActiveMQBytesMessage)message).getBodyLength());
                        Assert.assertEquals((long)"a".getBytes()[0], (long)((ActiveMQBytesMessage)message).readByte());
                    }
                    catch (JMSException | Error e) {
                        ActiveMQConcurrentDecompressionTest.this.assertionError = new AssertionError("Exception in thread", e);
                    }
                }
            });
        }
        Session producerSession = connection.createSession(false, 1);
        MessageProducer messageProducer = producerSession.createProducer((Destination)producerSession.createTopic("foo.bar"));
        for (int i = 0; i < 1000; ++i) {
            BytesMessage bytesMessage = producerSession.createBytesMessage();
            bytesMessage.writeBytes("a".getBytes());
            messageProducer.send((Message)bytesMessage);
            if (this.assertionError == null) continue;
            throw this.assertionError;
        }
        Assert.assertNull((Object)this.assertionError);
    }
}

