/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;

public class JMSDurableTopicNoLocalTest
extends EmbeddedBrokerTestSupport {
    protected String bindAddress;

    public void testConsumeNoLocal() throws Exception {
        String TEST_NAME = ((Object)((Object)this)).getClass().getName();
        Connection connection = this.createConnection();
        connection.setClientID(TEST_NAME);
        Session session = connection.createSession(false, 1);
        TopicSubscriber subscriber = session.createDurableSubscriber((Topic)this.destination, "topicUser2", null, true);
        final CountDownLatch latch = new CountDownLatch(1);
        subscriber.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                System.out.println("Receive a message " + message);
                latch.countDown();
            }
        });
        connection.start();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        TextMessage message = session.createTextMessage("THIS IS A TEST");
        producer.send((Message)message);
        producer.close();
        latch.await(5L, TimeUnit.SECONDS);
        JMSDurableTopicNoLocalTest.assertEquals((long)latch.getCount(), (long)1L);
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "vm://localhost";
        this.useTopic = true;
        super.setUp();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(false);
        answer.setPersistent(true);
        answer.setDeleteAllMessagesOnStartup(true);
        answer.addConnector(this.bindAddress);
        return answer;
    }
}

