/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.ArrayList;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.store.kahadb.plist.PListStoreImpl;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ6459Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ6459Test.class);
    private static final String DESTINATION = "testQ1";
    private static final int MESSAGES_TO_SEND = 4000;
    private String TRANSPORT_URL = "tcp://0.0.0.0:0";
    BrokerService broker;

    @Before
    public void createBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setUseJmx(true);
        PolicyMap policyMap = new PolicyMap();
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry pe = new PolicyEntry();
        pe.setTopicPrefetch(50);
        pe.setTopic(">");
        entries.add(pe);
        policyMap.setPolicyEntries(entries);
        this.broker.setDestinationPolicy(policyMap);
        SystemUsage systemUsage = this.broker.getSystemUsage();
        systemUsage.getTempUsage().setLimit(0x3200000L);
        systemUsage.getMemoryUsage().setLimit(819200L);
        PListStoreImpl pListStore = (PListStoreImpl)this.broker.getTempDataStore();
        pListStore.setJournalMaxFileLength(24576);
        pListStore.setCleanupInterval(2000L);
        this.broker.addConnector(this.TRANSPORT_URL);
        this.broker.start();
        this.broker.waitUntilStarted();
        this.TRANSPORT_URL = this.broker.getTransportConnectorByScheme("tcp").getPublishableConnectString();
    }

    @After
    public void stopBroker() throws Exception {
        this.broker.stop();
    }

    @Test
    public void testTempPercentUsageDecreases() throws Exception {
        MessageConsumer messageConsumer = this.createConsumer();
        this.sendMessages(4000);
        final BrokerViewMBean brokerView = this.getBrokerView(this.broker);
        LOG.info("tempPercentageUsage is " + brokerView.getTempPercentUsage());
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("tempPercentageUsage now " + brokerView.getTempPercentUsage());
                return brokerView.getTempPercentUsage() > 50;
            }
        });
        final int tempPercentUsageWithConsumer = brokerView.getTempPercentUsage();
        Assert.assertTrue((String)" tempPercentageUsage ", (50 < tempPercentUsageWithConsumer ? 1 : 0) != 0);
        messageConsumer.close();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("tempPercentageUsage now (after consumer closed) " + brokerView.getTempPercentUsage());
                return tempPercentUsageWithConsumer > brokerView.getTempPercentUsage();
            }
        });
        Assert.assertTrue((String)"tempPercentageUsage should be less after consumer has closed", (tempPercentUsageWithConsumer > brokerView.getTempPercentUsage() ? 1 : 0) != 0);
    }

    private MessageConsumer createConsumer() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("admin", "admin", this.TRANSPORT_URL);
        Connection connection = connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Topic destination = session.createTopic(DESTINATION);
        MessageConsumer messageConsumer = session.createConsumer((Destination)destination);
        return messageConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long sendMessages(int messageCount) throws Exception {
        long numberOfMessageSent = 0L;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("admin", "admin", this.TRANSPORT_URL);
        ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();
        connection.start();
        String blob = new String(new byte[4096]);
        try {
            Session producerSession = connection.createSession(true, 0);
            MessageProducer jmsProducer = producerSession.createProducer((Destination)producerSession.createTopic(DESTINATION));
            TextMessage sendMessage = producerSession.createTextMessage(blob);
            for (int i = 0; i < messageCount; ++i) {
                jmsProducer.send((Message)sendMessage);
                producerSession.commit();
                ++numberOfMessageSent;
            }
            LOG.info(" Finished after producing : " + numberOfMessageSent);
            Long l = numberOfMessageSent;
            return l;
        }
        catch (Exception ex) {
            LOG.info("Exception received producing ", (Throwable)ex);
            LOG.info("finishing after exception :" + numberOfMessageSent);
            Long l = numberOfMessageSent;
            return l;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private BrokerViewMBean getBrokerView(BrokerService broker) throws Exception {
        BrokerView brokerViewMBean = broker.getAdminView();
        return brokerViewMBean;
    }
}

