/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.transport.RequestTimedOutIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ6240Test
extends EmbeddedBrokerTestSupport {
    static final Logger LOG = LoggerFactory.getLogger(AMQ6240Test.class);

    public void testBlockedTxProducerConnectionTimeoutConnectionCanClose() throws Exception {
        final ActiveMQConnection cx = (ActiveMQConnection)this.createConnection();
        final ActiveMQDestination queue = this.createDestination("noPfc");
        cx.setSendTimeout(4000);
        cx.setCloseTimeout(1000);
        final AtomicInteger exceptionCount = new AtomicInteger(0);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int count;
                try {
                    LOG.info("Sender thread starting");
                    Session session = cx.createSession(true, 0);
                    MessageProducer producer = session.createProducer((Destination)queue);
                    BytesMessage message = session.createBytesMessage();
                    message.writeBytes(new byte[8192]);
                    for (count = 0; count < 100; ++count) {
                        producer.send((Message)message);
                    }
                    LOG.info("Done sending..");
                }
                catch (JMSException e) {
                    if (e.getCause() instanceof RequestTimedOutIOException) {
                        exceptionCount.incrementAndGet();
                        LOG.info("Got expected send time out on message: " + count);
                    } else {
                        e.printStackTrace();
                    }
                    return;
                }
            }
        };
        cx.start();
        Thread producerThread2 = new Thread(r);
        producerThread2.start();
        producerThread2.join(7000L);
        cx.close();
        AMQ6240Test.assertTrue((String)"No exception from the broker", (exceptionCount.get() > 0 ? 1 : 0) != 0);
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.getManagementContext().setCreateConnector(false);
        answer.addConnector(this.bindAddress);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry noProducerFlowControl = new PolicyEntry();
        noProducerFlowControl.setProducerFlowControl(false);
        policyMap.put((ActiveMQDestination)new ActiveMQQueue("noPfc"), (Object)noProducerFlowControl);
        answer.setDestinationPolicy(policyMap);
        KahaDBPersistenceAdapter kahaDBPersistenceAdapter = new KahaDBPersistenceAdapter();
        kahaDBPersistenceAdapter.setJournalMaxFileLength(16384);
        answer.getSystemUsage().getStoreUsage().setLimit(34816L);
        answer.setDeleteAllMessagesOnStartup(true);
        return answer;
    }
}

