/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ6117Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ6117Test.class);
    private BrokerService broker;

    @Test
    public void testViewIsStale() throws Exception {
        int MSG_COUNT = 10;
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.broker.getVmConnectorURI());
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("Test-Queue");
        Queue dlq = session.createQueue("ActiveMQ.DLQ");
        MessageProducer producer = session.createProducer((Destination)queue);
        session.createProducer((Destination)dlq);
        for (int i = 0; i < 10; ++i) {
            producer.send(session.createMessage(), 2, 4, 1000L);
        }
        final QueueViewMBean queueView = this.getProxyToQueue(dlq.getQueueName());
        Assert.assertTrue((String)"Message should be DLQ'd", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return queueView.getQueueSize() == 10L;
            }
        }));
        LOG.info("DLQ has captured all expired messages");
        LinkedList<String> browsed = new LinkedList<String>();
        CompositeData[] elements = queueView.browse();
        Assert.assertEquals((long)10L, (long)elements.length);
        for (CompositeData element : elements) {
            String messageID = (String)element.get("JMSMessageID");
            LOG.debug("MessageID: {}", (Object)messageID);
            browsed.add(messageID);
        }
        String removedMsgId = (String)browsed.removeFirst();
        Assert.assertTrue((boolean)queueView.removeMessage(removedMsgId));
        Assert.assertEquals((long)9L, (long)queueView.getQueueSize());
        elements = queueView.browse();
        Assert.assertEquals((long)9L, (long)elements.length);
        for (CompositeData element : elements) {
            String messageID = (String)element.get("JMSMessageID");
            LOG.debug("MessageID: {}", (Object)messageID);
            Assert.assertFalse((boolean)messageID.equals(removedMsgId));
        }
    }

    @Before
    public void setup() throws Exception {
        PolicyMap policyMap = new PolicyMap();
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry pe = new PolicyEntry();
        pe.setExpireMessagesPeriod(1500L);
        pe.setQueue(">");
        entries.add(pe);
        policyMap.setPolicyEntries(entries);
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setPersistent(true);
        this.broker.setUseJmx(true);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    protected QueueViewMBean getProxyToQueue(String name) throws MalformedObjectNameException, JMSException {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + name);
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }
}

