/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Random;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class AMQ5381Test {
    public static final byte[] ORIG_MSG_CONTENT = AMQ5381Test.randomByteArray();
    public static final String AMQ5381_EXCEPTION_MESSAGE = "java.util.zip.DataFormatException: incorrect header check";
    private BrokerService brokerService;
    private String brokerURI;
    @Rule
    public TestName name = new TestName();
    protected static final int MAX_RANDOM_BYTE_ARRAY_SIZE_KB = 128;

    @Before
    public void startBroker() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(false);
        this.brokerService.addConnector("tcp://localhost:0");
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        this.brokerURI = this.brokerService.getTransportConnectorByScheme("tcp").getPublishableConnectString();
    }

    @After
    public void stopBroker() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    private ActiveMQConnection createConnection(boolean useCompression) throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerURI);
        factory.setUseCompression(useCompression);
        Connection connection = factory.createConnection();
        connection.start();
        return (ActiveMQConnection)connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void amq5381Test() throws Exception {
        ActiveMQConnection consumerConnection = this.createConnection(true);
        Session consumerSession = consumerConnection.createSession(false, 1);
        Queue consumerQueue = consumerSession.createQueue(this.name.getMethodName());
        MessageConsumer consumer = consumerSession.createConsumer((Destination)consumerQueue);
        ActiveMQConnection producerConnection = this.createConnection(false);
        Session producerSession = producerConnection.createSession(false, 1);
        Queue producerQueue = producerSession.createQueue(this.name.getMethodName());
        try {
            ActiveMQBytesMessage messageProduced = (ActiveMQBytesMessage)producerSession.createBytesMessage();
            messageProduced.writeBytes(ORIG_MSG_CONTENT);
            Assert.assertFalse((boolean)messageProduced.isReadOnlyBody());
            Assert.assertFalse((String)"Produced Message's 'compressed' flag should remain false until the message is sent (where it will be compressed, if necessary)", (boolean)messageProduced.isCompressed());
            MessageProducer producer = producerSession.createProducer(null);
            producer.send((Destination)producerQueue, (Message)messageProduced);
            Assert.assertEquals((String)"Once sent, the produced Message's 'compressed' flag should match its Connection's 'useCompression' flag", (Object)producerConnection.isUseCompression(), (Object)messageProduced.isCompressed());
            ActiveMQBytesMessage messageConsumed = (ActiveMQBytesMessage)consumer.receive();
            Assert.assertNotNull((Object)messageConsumed);
            Assert.assertTrue((String)"Consumed Message should be read-only", (boolean)messageConsumed.isReadOnlyBody());
            Assert.assertEquals((String)"Consumed Message's 'compressed' flag should match the produced Message's 'compressed' flag", (Object)messageProduced.isCompressed(), (Object)messageConsumed.isCompressed());
            byte[] consumedMsgContent = new byte[(int)messageConsumed.getBodyLength()];
            messageConsumed.readBytes(consumedMsgContent);
            Assert.assertTrue((String)"Consumed Message content should match the original Message content", (boolean)Arrays.equals(ORIG_MSG_CONTENT, consumedMsgContent));
            AMQ5381Test.makeWritable((ActiveMQMessage)messageConsumed);
            try {
                messageConsumed.setStringProperty(this.getClass().getName(), "test");
            }
            catch (JMSException jmsE) {
                if (AMQ5381_EXCEPTION_MESSAGE.equals(jmsE.getMessage())) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    jmsE.printStackTrace(pw);
                    Assert.fail((String)("AMQ5381 Error State Achieved: attempted to decompress BytesMessage contents that are not compressed\n" + sw.toString()));
                }
                throw jmsE;
            }
            Assert.assertEquals((String)"The consumed Message's 'compressed' flag should still match the produced Message's 'compressed' flag after it has been made writable", (Object)messageProduced.isCompressed(), (Object)messageConsumed.isCompressed());
            AMQ5381Test.simulatePublish(messageConsumed);
            byte[] modifiedMsgContent = new byte[(int)messageConsumed.getBodyLength()];
            messageConsumed.readBytes(modifiedMsgContent);
            Assert.assertTrue((String)"After the message properties are modified and it is re-published, its message content should still match the original message content", (boolean)Arrays.equals(ORIG_MSG_CONTENT, modifiedMsgContent));
        }
        finally {
            producerSession.close();
            producerConnection.close();
            consumerSession.close();
            consumerConnection.close();
        }
    }

    protected static byte[] randomByteArray() {
        Random random = new Random();
        byte[] byteArray = new byte[random.nextInt(131072)];
        random.nextBytes(byteArray);
        return byteArray;
    }

    protected static void makeWritable(ActiveMQMessage message) {
        message.setReadOnlyBody(false);
        message.setReadOnlyProperties(false);
    }

    protected static void simulatePublish(ActiveMQBytesMessage message) throws JMSException {
        message.reset();
        message.onSend();
    }
}

