/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ5336Test {
    private BrokerService brokerService;
    private String connectionUri;

    @Before
    public void before() throws Exception {
        this.brokerService = new BrokerService();
        TransportConnector connector = this.brokerService.addConnector("tcp://localhost:0");
        this.connectionUri = connector.getPublishableConnectString();
        this.brokerService.setDeleteAllMessagesOnStartup(true);
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
    }

    @After
    public void after() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
    }

    @Test
    public void test() throws Exception {
        String uri = "failover:(" + this.connectionUri + ")?randomize=false&nested.socket.tcpNoDelay=true&priorityBackup=true&priorityURIs=" + this.connectionUri + "&initialReconnectDelay=1000&useExponentialBackOff=false";
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(uri);
        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
        connection.start();
        FailoverTransport failover = (FailoverTransport)connection.getTransport().narrow(FailoverTransport.class);
        Assert.assertNotNull((Object)failover);
        Assert.assertTrue((boolean)failover.isConnectedToPriority());
        connection.close();
    }
}

