/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.DurableSubscriptionViewMBean;
import org.apache.activemq.broker.region.policy.FilePendingDurableSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingDurableSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.StorePendingDurableSubscriberMessageStoragePolicy;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class AMQ4656Test {
    private static final transient Logger LOG = LoggerFactory.getLogger(AMQ4656Test.class);
    private static BrokerService brokerService;
    private static String BROKER_ADDRESS;
    private String connectionUri;
    @Parameterized.Parameter
    public PendingDurableSubscriberMessageStoragePolicy pendingDurableSubPolicy;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> getTestParameters() {
        return Arrays.asList({new FilePendingDurableSubscriberMessageStoragePolicy()}, {new StorePendingDurableSubscriberMessageStoragePolicy()});
    }

    @Before
    public void setUp() throws Exception {
        brokerService = new BrokerService();
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setPendingDurableSubscriberPolicy(this.pendingDurableSubPolicy);
        policyMap.setDefaultEntry(defaultEntry);
        brokerService.setDestinationPolicy(policyMap);
        brokerService.setPersistent(false);
        brokerService.setUseJmx(true);
        brokerService.setDeleteAllMessagesOnStartup(true);
        this.connectionUri = brokerService.addConnector(BROKER_ADDRESS).getPublishableConnectString();
        brokerService.start();
        brokerService.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        brokerService.stop();
        brokerService.waitUntilStopped();
    }

    @Test(timeout=90000L)
    public void testDurableConsumerEnqueueCountWithZeroPrefetch() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
        Connection connection = connectionFactory.createConnection();
        connection.setClientID(this.getClass().getName());
        connection.start();
        Session session = connection.createSession(false, 1);
        Topic destination = session.createTopic("DurableTopic");
        TopicSubscriber consumer = session.createDurableSubscriber(destination, "EnqueueSub");
        BrokerView brokerView = brokerService.getAdminView();
        ObjectName subName = brokerView.getDurableTopicSubscribers()[0];
        final DurableSubscriptionViewMBean sub = (DurableSubscriptionViewMBean)brokerService.getManagementContext().newProxyInstance(subName, DurableSubscriptionViewMBean.class, true);
        Assert.assertEquals((long)0L, (long)sub.getEnqueueCounter());
        Assert.assertEquals((long)0L, (long)sub.getDequeueCounter());
        Assert.assertEquals((long)0L, (long)sub.getPendingQueueSize());
        Assert.assertEquals((long)0L, (long)sub.getDispatchedCounter());
        Assert.assertEquals((long)0L, (long)sub.getDispatchedQueueSize());
        consumer.close();
        MessageProducer producer = session.createProducer((Destination)destination);
        for (int i = 0; i < 20; ++i) {
            producer.send(session.createMessage());
        }
        producer.close();
        consumer = session.createDurableSubscriber(destination, "EnqueueSub");
        Assert.assertTrue((String)"Should be an Active Subscription", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){
            final /* synthetic */ BrokerViewMBean val$brokerView;
            {
                this.val$brokerView = brokerViewMBean;
            }

            public boolean isSatisified() throws Exception {
                return this.val$brokerView.getDurableTopicSubscribers().length == 1;
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(25L)));
        Assert.assertTrue((String)"Should all be dispatched", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return sub.getDispatchedCounter() == 20L;
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(25L)));
        Assert.assertEquals((long)20L, (long)sub.getEnqueueCounter());
        Assert.assertEquals((long)0L, (long)sub.getDequeueCounter());
        Assert.assertEquals((long)0L, (long)sub.getPendingQueueSize());
        Assert.assertEquals((long)20L, (long)sub.getDispatchedCounter());
        Assert.assertEquals((long)20L, (long)sub.getDispatchedQueueSize());
        LOG.info("Pending Queue Size with no receives: {}", (Object)sub.getPendingQueueSize());
        Assert.assertNotNull((Object)consumer.receive(1000L));
        Assert.assertNotNull((Object)consumer.receive(1000L));
        consumer.close();
        LOG.info("Pending Queue Size with two receives: {}", (Object)sub.getPendingQueueSize());
        Assert.assertTrue((String)"Should be an Active Subscription", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){
            final /* synthetic */ BrokerViewMBean val$brokerView;
            {
                this.val$brokerView = brokerViewMBean;
            }

            public boolean isSatisified() throws Exception {
                return this.val$brokerView.getInactiveDurableTopicSubscribers().length == 1;
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(25L)));
        final DurableSubscriptionViewMBean inactive = (DurableSubscriptionViewMBean)brokerService.getManagementContext().newProxyInstance(subName, DurableSubscriptionViewMBean.class, true);
        Assert.assertTrue((String)"Should all be dispatched", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return inactive.getDequeueCounter() == 2L;
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(25L)));
        Assert.assertEquals((long)20L, (long)inactive.getEnqueueCounter());
        Assert.assertEquals((long)2L, (long)inactive.getDequeueCounter());
        Assert.assertEquals((long)18L, (long)inactive.getPendingQueueSize());
        Assert.assertEquals((long)20L, (long)inactive.getDispatchedCounter());
        Assert.assertEquals((long)0L, (long)inactive.getDispatchedQueueSize());
        session.close();
        connection.close();
    }

    static {
        BROKER_ADDRESS = "tcp://localhost:0";
    }
}

