/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Test;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.network.ConditionalNetworkBridgeFilterFactory;
import org.apache.activemq.network.NetworkBridgeFilterFactory;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4607Test
extends JmsMultipleBrokersTestSupport
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ4607Test.class);
    public static final int BROKER_COUNT = 3;
    public static final int CONSUMER_COUNT = 1;
    public static final int MESSAGE_COUNT = 0;
    public static final boolean CONDUIT = true;
    public static final int TIMEOUT = 20000;
    public boolean duplex = true;
    protected Map<String, MessageConsumer> consumerMap;
    Map<Thread, Throwable> unhandeledExceptions = new HashMap<Thread, Throwable>();

    private void assertNoUnhandeledExceptions() {
        for (Map.Entry<Thread, Throwable> e : this.unhandeledExceptions.entrySet()) {
            LOG.error("Thread:" + e.getKey() + " Had unexpected: " + e.getValue());
        }
        AMQ4607Test.assertTrue((String)("There are no unhandelled exceptions, see: log for detail on: " + this.unhandeledExceptions), (boolean)this.unhandeledExceptions.isEmpty());
    }

    public NetworkConnector bridge(String from, String to) throws Exception {
        NetworkConnector networkConnector = this.bridgeBrokers(from, to, true, -1, true);
        networkConnector.setSuppressDuplicateQueueSubscriptions(true);
        networkConnector.setDecreaseNetworkConsumerPriority(true);
        networkConnector.setConsumerTTL(1);
        networkConnector.setDuplex(this.duplex);
        return networkConnector;
    }

    public static Test suite() {
        return AMQ4607Test.suite(AMQ4607Test.class);
    }

    public void initCombos() {
        this.addCombinationValues("duplex", new Boolean[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testMigratingConsumer() throws Exception {
        MessageConsumer messageConsumer;
        this.bridge("Broker0", "Broker1");
        if (!this.duplex) {
            this.bridge("Broker1", "Broker0");
        }
        this.bridge("Broker1", "Broker2");
        if (!this.duplex) {
            this.bridge("Broker2", "Broker1");
        }
        this.bridge("Broker0", "Broker2");
        if (!this.duplex) {
            this.bridge("Broker2", "Broker0");
        }
        this.startAllBrokers();
        this.waitForBridgeFormation();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        this.sendMessages("Broker0", (Destination)dest, 1);
        for (int i = 0; i < 3; ++i) {
            int J;
            messageConsumer = this.createConsumer("Broker" + i, (Destination)dest, "DoNotConsume = 'true'");
            for (J = 0; J < 3; ++J) {
                this.assertExactConsumersConnect("Broker" + J, (Destination)dest, 1, 20000L);
            }
            this.assertNoUnhandeledExceptions();
            this.assertExactMessageCount("Broker" + i, (Destination)dest, 1, 20000L);
            messageConsumer.close();
            LOG.info("Check for no consumers..");
            for (J = 0; J < 3; ++J) {
                this.assertExactConsumersConnect("Broker" + J, (Destination)dest, 0, 20000L);
            }
        }
        String brokerId = "Broker2";
        messageConsumer = this.createConsumer("Broker2", (Destination)dest);
        AMQ4607Test.assertTrue((String)"Consumed ok", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return ((JmsMultipleBrokersTestSupport.BrokerItem)((AMQ4607Test)AMQ4607Test.this).brokers.get((Object)"Broker2")).allMessages.getMessageIds().size() == 1;
            }
        }));
        messageConsumer.close();
    }

    public void testMigratingConsumerFullCircle() throws Exception {
        MessageConsumer messageConsumer;
        this.bridge("Broker0", "Broker1");
        if (!this.duplex) {
            this.bridge("Broker1", "Broker0");
        }
        this.bridge("Broker1", "Broker2");
        if (!this.duplex) {
            this.bridge("Broker2", "Broker1");
        }
        this.bridge("Broker0", "Broker2");
        if (!this.duplex) {
            this.bridge("Broker2", "Broker0");
        }
        ConditionalNetworkBridgeFilterFactory conditionalNetworkBridgeFilterFactory = new ConditionalNetworkBridgeFilterFactory();
        conditionalNetworkBridgeFilterFactory.setReplayDelay(0);
        conditionalNetworkBridgeFilterFactory.setReplayWhenNoConsumers(true);
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker2")).broker.getDestinationPolicy().getDefaultEntry().setNetworkBridgeFilterFactory((NetworkBridgeFilterFactory)conditionalNetworkBridgeFilterFactory);
        this.startAllBrokers();
        this.waitForBridgeFormation();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        this.sendMessages("Broker0", (Destination)dest, 1);
        for (int i = 0; i < 3; ++i) {
            int J;
            messageConsumer = this.createConsumer("Broker" + i, (Destination)dest, "DoNotConsume = 'true'");
            for (J = 0; J < 3; ++J) {
                this.assertExactConsumersConnect("Broker" + J, (Destination)dest, 1, 20000L);
            }
            this.assertNoUnhandeledExceptions();
            this.assertExactMessageCount("Broker" + i, (Destination)dest, 1, 20000L);
            messageConsumer.close();
            LOG.info("Check for no consumers..");
            for (J = 0; J < 3; ++J) {
                this.assertExactConsumersConnect("Broker" + J, (Destination)dest, 0, 20000L);
            }
        }
        LOG.info("Consume from origin...");
        String brokerId = "Broker0";
        messageConsumer = this.createConsumer("Broker0", (Destination)dest);
        AMQ4607Test.assertTrue((String)"Consumed ok", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return ((JmsMultipleBrokersTestSupport.BrokerItem)((AMQ4607Test)AMQ4607Test.this).brokers.get((Object)"Broker0")).allMessages.getMessageIds().size() == 1;
            }
        }));
        messageConsumer.close();
    }

    public void testMigratingConsumerSelectorAwareTrue() throws Exception {
        this.bridge("Broker0", "Broker1");
        if (!this.duplex) {
            this.bridge("Broker1", "Broker0");
        }
        ConditionalNetworkBridgeFilterFactory conditionalNetworkBridgeFilterFactory = new ConditionalNetworkBridgeFilterFactory();
        conditionalNetworkBridgeFilterFactory.setReplayDelay(0);
        conditionalNetworkBridgeFilterFactory.setReplayWhenNoConsumers(true);
        conditionalNetworkBridgeFilterFactory.setSelectorAware(true);
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker1")).broker.getDestinationPolicy().getDefaultEntry().setNetworkBridgeFilterFactory((NetworkBridgeFilterFactory)conditionalNetworkBridgeFilterFactory);
        this.startAllBrokers();
        this.waitForBridgeFormation();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        this.sendMessages("Broker0", (Destination)dest, 1);
        this.assertExactMessageCount("Broker0", (Destination)dest, 1, 20000L);
        MessageConsumer messageConsumerNoMatch = this.createConsumer("Broker1", (Destination)dest, "DoNotConsume = 'true'");
        this.assertExactConsumersConnect("Broker0", (Destination)dest, 1, 20000L);
        this.assertExactConsumersConnect("Broker1", (Destination)dest, 1, 20000L);
        this.assertExactMessageCount("Broker1", (Destination)dest, 1, 20000L);
        this.assertExactMessageCount("Broker0", (Destination)dest, 0, 20000L);
        String brokerId = "Broker0";
        MessageConsumer messageConsumer = this.createConsumer("Broker0", (Destination)dest);
        this.assertExactConsumersConnect("Broker0", (Destination)dest, 2, 20000L);
        this.assertExactConsumersConnect("Broker1", (Destination)dest, 2, 20000L);
        AMQ4607Test.assertTrue((String)"Consumed ok", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return ((JmsMultipleBrokersTestSupport.BrokerItem)((AMQ4607Test)AMQ4607Test.this).brokers.get((Object)"Broker0")).allMessages.getMessageIds().size() == 1;
            }
        }));
        messageConsumer.close();
    }

    public void testMigratingConsumerSelectorAwareFalse() throws Exception {
        this.bridge("Broker0", "Broker1");
        if (!this.duplex) {
            this.bridge("Broker1", "Broker0");
        }
        ConditionalNetworkBridgeFilterFactory conditionalNetworkBridgeFilterFactory = new ConditionalNetworkBridgeFilterFactory();
        conditionalNetworkBridgeFilterFactory.setReplayDelay(0);
        conditionalNetworkBridgeFilterFactory.setReplayWhenNoConsumers(true);
        conditionalNetworkBridgeFilterFactory.setSelectorAware(false);
        ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker1")).broker.getDestinationPolicy().getDefaultEntry().setNetworkBridgeFilterFactory((NetworkBridgeFilterFactory)conditionalNetworkBridgeFilterFactory);
        this.startAllBrokers();
        this.waitForBridgeFormation();
        ActiveMQDestination dest = this.createDestination("TEST.FOO", false);
        this.sendMessages("Broker0", (Destination)dest, 1);
        this.assertExactMessageCount("Broker0", (Destination)dest, 1, 20000L);
        MessageConsumer messageConsumerNoMatch = this.createConsumer("Broker1", (Destination)dest, "DoNotConsume = 'true'");
        this.assertExactConsumersConnect("Broker0", (Destination)dest, 1, 20000L);
        this.assertExactConsumersConnect("Broker1", (Destination)dest, 1, 20000L);
        this.assertExactMessageCount("Broker1", (Destination)dest, 1, 20000L);
        this.assertExactMessageCount("Broker0", (Destination)dest, 0, 20000L);
        String brokerId = "Broker0";
        MessageConsumer messageConsumer = this.createConsumer("Broker0", (Destination)dest);
        this.assertExactConsumersConnect("Broker0", (Destination)dest, 2, 20000L);
        this.assertExactConsumersConnect("Broker1", (Destination)dest, 2, 20000L);
        this.assertExactMessageCount("Broker1", (Destination)dest, 1, 20000L);
        this.assertExactMessageCount("Broker0", (Destination)dest, 0, 20000L);
        AMQ4607Test.assertTrue((String)"Consumed ok", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return ((JmsMultipleBrokersTestSupport.BrokerItem)((AMQ4607Test)AMQ4607Test.this).brokers.get((Object)"Broker0")).allMessages.getMessageIds().size() == 0;
            }
        }));
        messageConsumer.close();
    }

    protected void assertExactMessageCount(final String brokerName, Destination destination, final int count, long timeout) throws Exception {
        ManagementContext context = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)brokerName)).broker.getManagementContext();
        final QueueViewMBean queueViewMBean = (QueueViewMBean)context.newProxyInstance(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)brokerName)).broker.getAdminView().getQueues()[0], QueueViewMBean.class, false);
        AMQ4607Test.assertTrue((String)("Excepected queue depth: " + count + " on: " + brokerName), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                long currentCount = queueViewMBean.getQueueSize();
                LOG.info("On " + brokerName + " current queue size for " + queueViewMBean + ", " + currentCount);
                if ((long)count != currentCount) {
                    LOG.info("Sub IDs: " + Arrays.asList(queueViewMBean.getSubscriptions()));
                }
                return currentCount == (long)count;
            }
        }, (long)timeout));
    }

    protected void assertExactConsumersConnect(final String brokerName, Destination destination, final int count, long timeout) throws Exception {
        final ManagementContext context = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)brokerName)).broker.getManagementContext();
        AMQ4607Test.assertTrue((String)("Excepected consumers count: " + count + " on: " + brokerName), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                try {
                    QueueViewMBean queueViewMBean = (QueueViewMBean)context.newProxyInstance(((JmsMultipleBrokersTestSupport.BrokerItem)((AMQ4607Test)AMQ4607Test.this).brokers.get((Object)brokerName)).broker.getAdminView().getQueues()[0], QueueViewMBean.class, false);
                    long currentCount = queueViewMBean.getConsumerCount();
                    LOG.info("On " + brokerName + " current consumer count for " + queueViewMBean + ", " + currentCount);
                    if ((long)count != currentCount) {
                        LOG.info("Sub IDs: " + Arrays.asList(queueViewMBean.getSubscriptions()));
                    }
                    return currentCount == (long)count;
                }
                catch (Exception e) {
                    LOG.warn("Unexpected: " + e, (Throwable)e);
                    return false;
                }
            }
        }, (long)timeout));
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.unhandeledExceptions.clear();
        Thread.setDefaultUncaughtExceptionHandler(this);
        for (int i = 0; i < 3; ++i) {
            this.createBroker(new URI("broker:(tcp://localhost:6161" + i + ")/Broker" + i + "?persistent=false&useJmx=true"));
        }
        this.consumerMap = new LinkedHashMap<String, MessageConsumer>();
    }

    @Override
    protected void configureBroker(BrokerService brokerService) {
        PolicyEntry policyEntry = new PolicyEntry();
        policyEntry.setExpireMessagesPeriod(0L);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setDefaultEntry(policyEntry);
        brokerService.setDestinationPolicy(policyMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Map<Thread, Throwable> map = this.unhandeledExceptions;
        synchronized (map) {
            this.unhandeledExceptions.put(t, e);
        }
    }
}

