/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.net.URI;
import java.util.Date;
import java.util.Enumeration;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4595Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ4595Test.class);
    private BrokerService broker;
    private URI connectUri;
    private ActiveMQConnectionFactory factory;

    @Before
    public void startBroker() throws Exception {
        this.broker = new BrokerService();
        TransportConnector connector = this.broker.addConnector("vm://localhost");
        this.broker.deleteAllMessages();
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x10000000L);
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectUri = connector.getConnectUri();
        this.factory = new ActiveMQConnectionFactory(this.connectUri);
    }

    @After
    public void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test(timeout=120000L)
    public void testBrowsingSmallBatch() throws JMSException {
        this.doTestBrowsing(100);
    }

    @Test(timeout=160000L)
    public void testBrowsingMediumBatch() throws JMSException {
        this.doTestBrowsing(1000);
    }

    @Test(timeout=300000L)
    public void testBrowsingLargeBatch() throws JMSException {
        this.doTestBrowsing(10000);
    }

    private void doTestBrowsing(int messageToSend) throws JMSException {
        ActiveMQQueue queue = new ActiveMQQueue("TEST");
        ActiveMQConnection producerConnection = (ActiveMQConnection)this.factory.createConnection();
        producerConnection.setUseAsyncSend(true);
        producerConnection.start();
        Session producerSession = producerConnection.createSession(false, 1);
        MessageProducer producer = producerSession.createProducer((Destination)queue);
        producer.setDeliveryMode(2);
        for (int i = 1; i <= messageToSend; ++i) {
            String msgStr = this.provideMessageText(i, 8192);
            producer.send((Message)producerSession.createTextMessage(msgStr));
            if (i % 1000 != 0) continue;
            LOG.info("P&C: {}", (Object)msgStr.substring(0, 100));
        }
        producerConnection.close();
        LOG.info("Mem usage after producer done: " + this.broker.getSystemUsage().getMemoryUsage().getPercentUsage() + "%");
        Connection connection = this.factory.createConnection();
        connection.start();
        Session session = connection.createSession(true, 1);
        QueueBrowser browser = session.createBrowser((Queue)queue);
        Enumeration enumeration = browser.getEnumeration();
        int browsed = 0;
        while (enumeration.hasMoreElements()) {
            TextMessage m = (TextMessage)enumeration.nextElement();
            if (++browsed % 1000 != 0) continue;
            LOG.info("B[{}]: {}", (Object)browsed, (Object)m.getText().substring(0, 100));
        }
        browser.close();
        session.close();
        connection.close();
        LOG.info("Mem usage after browser closed: " + this.broker.getSystemUsage().getMemoryUsage().getPercentUsage() + "%");
        Assert.assertEquals((long)messageToSend, (long)browsed);
        browser.close();
    }

    public String provideMessageText(int messageNumber, int messageSize) {
        StringBuilder buf = new StringBuilder();
        buf.append("Message: ");
        if (messageNumber > 0) {
            buf.append(messageNumber);
        }
        buf.append(" sent at: ").append(new Date());
        if (buf.length() > messageSize) {
            return buf.substring(0, messageSize);
        }
        for (int i = buf.length(); i < messageSize; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }
}

