/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.Topic;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.IndividualDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ4517Test {
    private BrokerService brokerService;
    private String connectionUri;

    @Before
    public void setup() throws Exception {
        this.brokerService = new BrokerService();
        this.connectionUri = this.brokerService.addConnector("tcp://localhost:0").getPublishableConnectString();
        IndividualDeadLetterStrategy strategy = new IndividualDeadLetterStrategy();
        strategy.setUseQueueForQueueMessages(true);
        strategy.setQueuePrefix("DLQ.");
        strategy.setProcessNonPersistent(false);
        strategy.setProcessExpired(false);
        PolicyEntry policy = new PolicyEntry();
        policy.setTimeBeforeDispatchStarts(3000);
        policy.setDeadLetterStrategy((DeadLetterStrategy)strategy);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        this.brokerService.setDestinationPolicy(pMap);
        this.brokerService.setPersistent(false);
        this.brokerService.start();
    }

    @After
    public void stop() throws Exception {
        this.brokerService.stop();
    }

    @Test(timeout=360000L)
    public void test() throws Exception {
        final ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.connectionUri);
        final AtomicBoolean advised = new AtomicBoolean(false);
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 1);
        Topic dlqDestination = session.createTopic("ActiveMQ.Advisory.MessageDLQd.>");
        MessageConsumer consumer = session.createConsumer((Destination)dlqDestination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                advised.set(true);
            }
        });
        connection.start();
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
                    Session session = connection.createSession(false, 1);
                    TemporaryQueue destination = session.createTemporaryQueue();
                    MessageProducer producer = session.createProducer((Destination)destination);
                    producer.setDeliveryMode(1);
                    producer.setTimeToLive(400L);
                    producer.send((Message)session.createTextMessage());
                    producer.send((Message)session.createTextMessage());
                    TimeUnit.MILLISECONDS.sleep(500L);
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        service.shutdown();
        Assert.assertTrue((boolean)service.awaitTermination(1L, TimeUnit.MINUTES));
        Assert.assertFalse((String)"Should not get any Advisories for DLQ'd Messages", (boolean)advised.get());
    }
}

