/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.Wait;
import org.junit.Assert;

public class AMQ4148Test
extends JmsMultipleBrokersTestSupport {
    public void test() throws Exception {
        BrokerService hub = this.createBroker(new URI("broker:(vm://hub)/hub?persistent=false"));
        final BrokerService[] spokes = new BrokerService[4];
        for (int i = 0; i < spokes.length; ++i) {
            spokes[i] = this.createBroker(new URI("broker:(vm://spoke" + i + ")/spoke" + i + "?persistent=false"));
        }
        this.startAllBrokers();
        ActiveMQDestination testQueue = this.createDestination(AMQ4148Test.class.getSimpleName() + ".queue", false);
        NetworkConnector[] ncs = new NetworkConnector[spokes.length];
        for (int i = 0; i < spokes.length; ++i) {
            NetworkConnector nc = this.bridgeBrokers("hub", "spoke" + i);
            nc.setNetworkTTL(1);
            nc.setDuplex(true);
            nc.setConduitSubscriptions(false);
            nc.setStaticallyIncludedDestinations(Arrays.asList(testQueue));
            nc.start();
            ncs[i] = nc;
        }
        this.waitForBridgeFormation();
        TimeUnit.SECONDS.sleep(5L);
        final Destination hubTestQueue = hub.getDestination(testQueue);
        AMQ4148Test.assertTrue((String)("Expecting {" + spokes.length + "} consumer but was {" + hubTestQueue.getConsumers().size() + "}"), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return spokes.length == hubTestQueue.getConsumers().size();
            }
        }));
        for (int i = 0; i < 4; ++i) {
            Destination spokeTestQueue = spokes[i].getDestination(testQueue);
            Assert.assertEquals((long)1L, (long)spokeTestQueue.getConsumers().size());
        }
        for (NetworkConnector nc : ncs) {
            nc.stop();
        }
    }
}

