/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.bugs.AMQ3841Test;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3879Test {
    static final Logger LOG = LoggerFactory.getLogger(AMQ3841Test.class);
    private BrokerService broker;
    private ActiveMQConnectionFactory factory;

    @Before
    public void setUp() throws Exception {
        this.broker = this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
        this.factory = new ActiveMQConnectionFactory("vm://localhost");
        this.factory.setAlwaysSyncSend(true);
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = null;
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setDeleteAllMessagesOnStartup(true);
        broker.setPersistent(false);
        broker.setUseJmx(false);
        broker.setBrokerName("localhost");
        broker.addConnector("vm://localhost");
        return broker;
    }

    @Test
    public void testConnectionDletesWrongTempDests() throws Exception {
        final Connection connection1 = this.factory.createConnection();
        Connection connection2 = this.factory.createConnection();
        Session session1 = connection1.createSession(false, 1);
        Session session2 = connection2.createSession(false, 1);
        ActiveMQTopic tempDestAdvisory = AdvisorySupport.TEMP_QUEUE_ADVISORY_TOPIC;
        MessageConsumer advisoryConsumer = session1.createConsumer((Destination)tempDestAdvisory);
        connection1.start();
        TemporaryQueue tempQueue = session2.createTemporaryQueue();
        MessageProducer tempProducer = session2.createProducer((Destination)tempQueue);
        Assert.assertNotNull((Object)advisoryConsumer.receive(5000L));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(20L);
                    connection1.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
        for (int i = 0; i < 256; ++i) {
            TextMessage msg = session2.createTextMessage("Temp Data");
            tempProducer.send((Message)msg);
            Thread.sleep(2L);
        }
        t.join();
    }
}

