/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.TextMessage;
import jakarta.jms.XAConnection;
import jakarta.jms.XAConnectionFactory;
import jakarta.jms.XASession;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageProducer;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ3465Test {
    private final String xaDestinationName = "DestinationXA";
    private final String destinationName = "Destination";
    private BrokerService broker;
    private String connectionUri;
    private long txGenerator = System.currentTimeMillis();
    private XAConnectionFactory xaConnectionFactory;
    private ConnectionFactory connectionFactory;

    @Before
    public void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        this.broker.addConnector("tcp://0.0.0.0:0");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
        this.connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
        this.xaConnectionFactory = new ActiveMQXAConnectionFactory(this.connectionUri);
    }

    @After
    public void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test
    public void testMixedXAandNonXAorTXSessions() throws Exception {
        XAConnection xaConnection = this.xaConnectionFactory.createXAConnection();
        xaConnection.start();
        XASession session = xaConnection.createXASession();
        XAResource resource = session.getXAResource();
        ActiveMQQueue dest = new ActiveMQQueue("DestinationXA");
        Xid tid = this.createXid();
        resource.start(tid, 0);
        MessageProducer producer = session.createProducer((Destination)dest);
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("Some Text");
        producer.send((Message)message);
        resource.end(tid, 0x4000000);
        resource.commit(tid, true);
        session.close();
        session = xaConnection.createXASession();
        MessageConsumer consumer = session.createConsumer((Destination)dest);
        tid = this.createXid();
        resource = session.getXAResource();
        resource.start(tid, 0);
        TextMessage receivedMessage = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)receivedMessage);
        Assert.assertEquals((Object)"Some Text", (Object)receivedMessage.getText());
        resource.end(tid, 0x4000000);
        Connection connection2 = this.connectionFactory.createConnection();
        connection2.start();
        ActiveMQSession session2 = (ActiveMQSession)connection2.createSession(false, 1);
        if (session2.isTransacted()) {
            session2.rollback();
        }
        session2.close();
        resource.commit(tid, true);
    }

    @Test
    public void testMixedXAandNonXALocalTXSessions() throws Exception {
        XAConnection xaConnection = this.xaConnectionFactory.createXAConnection();
        xaConnection.start();
        XASession session = xaConnection.createXASession();
        XAResource resource = session.getXAResource();
        ActiveMQQueue dest = new ActiveMQQueue("DestinationXA");
        Xid tid = this.createXid();
        resource.start(tid, 0);
        MessageProducer producer = session.createProducer((Destination)dest);
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setText("Some Text");
        producer.send((Message)message);
        resource.end(tid, 0x4000000);
        resource.commit(tid, true);
        session.close();
        session = xaConnection.createXASession();
        MessageConsumer consumer = session.createConsumer((Destination)dest);
        tid = this.createXid();
        resource = session.getXAResource();
        resource.start(tid, 0);
        TextMessage receivedMessage = (TextMessage)consumer.receive(1000L);
        Assert.assertNotNull((Object)receivedMessage);
        Assert.assertEquals((Object)"Some Text", (Object)receivedMessage.getText());
        resource.end(tid, 0x4000000);
        Connection connection2 = this.connectionFactory.createConnection();
        connection2.start();
        ActiveMQSession session2 = (ActiveMQSession)connection2.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("Destination");
        ActiveMQMessageProducer producer2 = (ActiveMQMessageProducer)session2.createProducer((Destination)destination);
        producer2.send((Message)session2.createTextMessage("Local-TX"));
        if (session2.isTransacted()) {
            session2.rollback();
        }
        session2.close();
        resource.commit(tid, true);
    }

    public Xid createXid() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        os.writeLong(++this.txGenerator);
        os.close();
        final byte[] bs = baos.toByteArray();
        return new Xid(){

            @Override
            public int getFormatId() {
                return 86;
            }

            @Override
            public byte[] getGlobalTransactionId() {
                return bs;
            }

            @Override
            public byte[] getBranchQualifier() {
                return bs;
            }
        };
    }
}

