/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.EmbeddedBrokerAndConnectionTestSupport;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.spring.ConsumerBean;

public class AMQ2585Test
extends EmbeddedBrokerAndConnectionTestSupport {
    private final Destination destination = new ActiveMQQueue("MyQueue");
    static final String LENGTH10STRING = "1234567890";
    private Session session;
    private MessageProducer producer;
    private ConsumerBean messageList;

    public void testOneMessageWithProperties() throws Exception {
        TextMessage message = this.session.createTextMessage(LENGTH10STRING);
        message.setStringProperty(LENGTH10STRING, LENGTH10STRING);
        this.producer.send((Message)message);
        this.messageList.assertMessagesArrived(1);
        ActiveMQTextMessage received = (ActiveMQTextMessage)this.messageList.flushMessages().get(0);
        AMQ2585Test.assertEquals((String)LENGTH10STRING, (String)received.getText());
        AMQ2585Test.assertTrue((received.getProperties().size() > 0 ? 1 : 0) != 0);
        AMQ2585Test.assertTrue((boolean)received.propertyExists(LENGTH10STRING));
        AMQ2585Test.assertEquals((String)LENGTH10STRING, (String)received.getStringProperty(LENGTH10STRING));
        int sizeShouldBeNoLessThan = LENGTH10STRING.length() * 4 + 1024;
        AMQ2585Test.assertTrue((String)("Message size was smaller than expected: " + received.getSize()), (received.getSize() >= sizeShouldBeNoLessThan ? 1 : 0) != 0);
        AMQ2585Test.assertFalse((LENGTH10STRING.length() * 2 == received.getSize() ? 1 : 0) != 0);
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = this.bindAddress + "?marshal=true";
        super.setUp();
        this.messageList = new ConsumerBean();
        this.messageList.setVerbose(true);
        this.session = this.connection.createSession(false, 1);
        MessageConsumer messageConsumer = this.session.createConsumer(this.destination);
        messageConsumer.setMessageListener((MessageListener)this.messageList);
        this.producer = this.session.createProducer(this.destination);
    }
}

