/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.region.Queue;
import org.junit.Assert;

public class AMQ2528Test
extends EmbeddedBrokerTestSupport {
    @Override
    protected void setUp() throws Exception {
        this.useTopic = false;
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveMatchingMessages() throws Exception {
        int NUM_MESSAGES = 100;
        String MESSAGE_ID = "id";
        try (Connection conn = this.createConnection();){
            conn.start();
            Session session = conn.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)this.destination);
            for (int id = 0; id < 100; ++id) {
                Message message = session.createMessage();
                message.setIntProperty("id", id);
                producer.send(message);
            }
            producer.close();
            session.close();
        }
        Queue queue = (Queue)this.broker.getRegionBroker().getDestinations(this.destination).iterator().next();
        Assert.assertEquals((long)50L, (long)queue.removeMatchingMessages("id < 50"));
        Assert.assertEquals((long)50L, (long)queue.removeMatchingMessages(""));
    }
}

