/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.VMPendingQueueMessageStoragePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ2401Test
extends TestCase
implements MessageListener {
    private BrokerService broker;
    private ActiveMQConnectionFactory factory;
    private static final int SEND_COUNT = 500;
    private static final int CONSUMER_COUNT = 50;
    private static final int PRODUCER_COUNT = 1;
    private static final int LOG_INTERVAL = 10;
    private static final Logger LOG = LoggerFactory.getLogger(AMQ2401Test.class);
    private final ArrayList<Service> services = new ArrayList(51);
    private int count = 0;
    private CountDownLatch latch;

    protected void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target" + File.separator + "test-data" + File.separator + "AMQ2401Test");
        this.broker.setDeleteAllMessagesOnStartup(true);
        String connectionUri = this.broker.addConnector("tcp://0.0.0.0:0").getPublishableConnectString();
        PolicyMap policies = new PolicyMap();
        PolicyEntry entry = new PolicyEntry();
        entry.setMemoryLimit(102400L);
        entry.setProducerFlowControl(true);
        entry.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new VMPendingQueueMessageStoragePolicy());
        entry.setQueue(">");
        policies.setDefaultEntry(entry);
        this.broker.setDestinationPolicy(policies);
        this.broker.setUseJmx(false);
        this.broker.start();
        this.broker.waitUntilStarted();
        this.factory = new ActiveMQConnectionFactory(connectionUri);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDupsOk() throws Exception {
        TestProducer p = null;
        TestConsumer c = null;
        try {
            int i;
            this.latch = new CountDownLatch(500);
            for (i = 0; i < 50; ++i) {
                TestConsumer consumer = new TestConsumer();
                consumer.start();
                this.services.add(consumer);
            }
            for (i = 0; i < 1; ++i) {
                TestProducer producer = new TestProducer();
                producer.start();
                this.services.add(producer);
            }
            this.waitForMessageReceipt(TimeUnit.SECONDS.toMillis(30L));
        }
        finally {
            if (p != null) {
                p.close();
            }
            if (c != null) {
                c.close();
            }
        }
    }

    public void onMessage(Message message) {
        this.latch.countDown();
        if (++this.count % 10 == 0) {
            LOG.debug("Received message " + this.count);
        }
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void waitForMessageReceipt(long timeout) throws InterruptedException, TimeoutException {
        if (!this.latch.await(timeout, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException(String.format("Consumner didn't receive expected # of messages, %d of %d received.", this.latch.getCount(), 500));
        }
    }

    private class TestConsumer
    implements Runnable,
    Service {
        ActiveMQConnection connection;
        Session session;
        MessageConsumer consumer;

        TestConsumer() throws Exception {
            AMQ2401Test.this.factory.setOptimizeAcknowledge(false);
            this.connection = (ActiveMQConnection)AMQ2401Test.this.factory.createConnection();
            this.session = this.connection.createSession(false, 3);
            this.consumer = this.session.createConsumer((Destination)this.session.createQueue("AMQ2401Test"));
            this.consumer.setMessageListener((MessageListener)AMQ2401Test.this);
        }

        @Override
        public void start() throws Exception {
            this.connection.start();
        }

        @Override
        public void close() {
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            while (AMQ2401Test.this.latch.getCount() > 0L) {
                try {
                    AMQ2401Test.this.onMessage(this.consumer.receive());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class TestProducer
    implements Runnable,
    Service {
        Thread thread = new Thread((Runnable)this, "TestProducer");
        BytesMessage message;
        Connection connection;
        Session session;
        MessageProducer producer;

        TestProducer() throws Exception {
            this.connection = AMQ2401Test.this.factory.createConnection();
            this.connection.start();
            this.session = this.connection.createSession(false, 3);
            this.producer = this.session.createProducer((Destination)this.session.createQueue("AMQ2401Test"));
        }

        @Override
        public void start() {
            this.thread.start();
        }

        @Override
        public void run() {
            int count = 500;
            for (int i = 1; i <= count; ++i) {
                try {
                    if (i % 10 == 0) {
                        LOG.debug("Sending: " + i);
                    }
                    this.message = this.session.createBytesMessage();
                    this.message.writeBytes(new byte[1024]);
                    this.producer.send((Message)this.message);
                    continue;
                }
                catch (JMSException jmse) {
                    jmse.printStackTrace();
                    break;
                }
            }
        }

        @Override
        public void close() {
            try {
                this.connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    private static interface Service {
        public void start() throws Exception;

        public void close();
    }
}

