/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualTopicDestinationMapAccessTest {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualTopicDestinationMapAccessTest.class);
    BrokerService brokerService;
    ConnectionFactory connectionFactory;

    @Before
    public void createBroker() throws Exception {
        this.createBroker(true);
    }

    public void createBroker(boolean delete) throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setDeleteAllMessagesOnStartup(delete);
        this.brokerService.setAdvisorySupport(false);
        this.brokerService.start();
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        ActiveMQPrefetchPolicy zeroPrefetch = new ActiveMQPrefetchPolicy();
        zeroPrefetch.setAll(0);
        activeMQConnectionFactory.setPrefetchPolicy(zeroPrefetch);
        this.connectionFactory = activeMQConnectionFactory;
    }

    @After
    public void stopBroker() throws Exception {
        this.brokerService.stop();
    }

    @Test
    @Ignore(value="perf test that needs manual comparator")
    public void testX() throws Exception {
        int numConnections = 200;
        int numDestinations = 10000;
        final AtomicInteger numConsumers = new AtomicInteger(10000);
        final AtomicInteger numProducers = new AtomicInteger(10000);
        ExecutorService executorService = Executors.newFixedThreadPool(200);
        for (int i = 0; i < 10000; ++i) {
            this.brokerService.getRegionBroker().addDestination(this.brokerService.getAdminConnectionContext(), (ActiveMQDestination)new ActiveMQQueue("Consumer." + i + ".VirtualTopic.TEST-" + i), false);
            this.brokerService.getRegionBroker().addDestination(this.brokerService.getAdminConnectionContext(), (ActiveMQDestination)new ActiveMQTopic("VirtualTopic.TEST-" + i), false);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    int opsCount = 0;
                    Connection connection1 = VirtualTopicDestinationMapAccessTest.this.connectionFactory.createConnection();
                    connection1.start();
                    Session session = connection1.createSession(false, 1);
                    MessageProducer producer = session.createProducer(null);
                    do {
                        int i;
                        boolean consumerOrProducer = opsCount++ % 2 == 0;
                        int n = i = consumerOrProducer ? numConsumers.decrementAndGet() : numProducers.decrementAndGet();
                        if (i <= 0) continue;
                        if (consumerOrProducer) {
                            session.createConsumer((Destination)new ActiveMQQueue("Consumer." + i + ".VirtualTopic.TEST-" + i));
                            continue;
                        }
                        producer.send((Destination)new ActiveMQTopic("VirtualTopic.TEST-" + i), (Message)new ActiveMQMessage());
                    } while (numConsumers.get() > 0 || numProducers.get() > 0);
                    connection1.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        for (int i = 0; i < 200; ++i) {
            executorService.execute(runnable);
        }
        long start = System.currentTimeMillis();
        LOG.info("Starting timer: " + start);
        executorService.shutdown();
        executorService.awaitTermination(5L, TimeUnit.MINUTES);
        LOG.info("Done, duration: " + (System.currentTimeMillis() - start));
    }
}

