/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMessageListener
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleMessageListener.class);
    private CountDownLatch messageReceivedToken;
    private String lastJMSDestination;

    public void onMessage(Message message) {
        try {
            Thread.sleep(2000L);
            if (message instanceof TextMessage) {
                LOG.info("Dest:" + message.getJMSDestination());
                this.lastJMSDestination = message.getJMSDestination().toString();
                Enumeration propertyNames = message.getPropertyNames();
                while (propertyNames.hasMoreElements()) {
                    Object e = propertyNames.nextElement();
                }
            }
            this.messageReceivedToken.countDown();
        }
        catch (JMSException e) {
            LOG.error("Error while listening to a message", (Object)message);
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while listening to a message", (Object)message);
        }
    }

    public void setCountDown(CountDownLatch countDown) {
        this.messageReceivedToken = countDown;
    }

    public String getLastJMSDestination() {
        return this.lastJMSDestination;
    }
}

