/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomVirtualTopicInterceptorWithLeadingWildcardTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CustomVirtualTopicInterceptorWithLeadingWildcardTest.class);
    protected int total = 10;
    protected Connection connection;

    protected ActiveMQDestination getConsumer1Destination() {
        return new ActiveMQQueue("q1.a.virtualtopic.topic");
    }

    protected ActiveMQDestination getConsumer2Destination() {
        return new ActiveMQQueue("q2.a.virtualtopic.topic");
    }

    protected ActiveMQDestination getProducerDestination() {
        return new ActiveMQTopic("virtualtopic.topic");
    }

    public void testVirtualTopicRouting() throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.start();
        LOG.info("validate no other messages on queues");
        try {
            Session session = this.connection.createSession(false, 1);
            ActiveMQDestination destination1 = this.getConsumer1Destination();
            ActiveMQDestination destination2 = this.getConsumer2Destination();
            MessageConsumer c1 = session.createConsumer((Destination)destination1, null);
            MessageConsumer c2 = session.createConsumer((Destination)destination2, null);
            LOG.info("send one simple message that should go to both consumers");
            MessageProducer producer = session.createProducer((Destination)this.getProducerDestination());
            CustomVirtualTopicInterceptorWithLeadingWildcardTest.assertNotNull((Object)producer);
            producer.send((Message)session.createTextMessage("Last Message"));
            CustomVirtualTopicInterceptorWithLeadingWildcardTest.assertNotNull((Object)c1.receive(3000L));
            CustomVirtualTopicInterceptorWithLeadingWildcardTest.assertNotNull((Object)c2.receive(3000L));
        }
        catch (JMSException e) {
            e.printStackTrace();
            CustomVirtualTopicInterceptorWithLeadingWildcardTest.fail((String)("unexpected ex while waiting for last messages: " + e));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        VirtualTopic virtualTopic = new VirtualTopic();
        virtualTopic.setName("virtualtopic.>");
        virtualTopic.setPrefix("*.*.");
        VirtualDestinationInterceptor interceptor = new VirtualDestinationInterceptor();
        interceptor.setVirtualDestinations(new VirtualDestination[]{virtualTopic});
        broker.setDestinationInterceptors(new DestinationInterceptor[]{interceptor});
        return broker;
    }
}

