/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import junit.framework.Test;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQDestination;

public class DestinationRemoveRestartTest
extends CombinationTestSupport {
    private static final String destinationName = "TEST";
    public byte destinationType = 1;
    BrokerService broker;

    protected void setUp() throws Exception {
        this.broker = this.createBroker();
    }

    private BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(false);
        broker.setPersistent(true);
        broker.setDeleteAllMessagesOnStartup(true);
        broker.start();
        return broker;
    }

    protected void tearDown() throws Exception {
        this.broker.stop();
    }

    public void initCombosForTestCheckDestinationRemoveActionAfterRestart() {
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2});
    }

    public void testCheckDestinationRemoveActionAfterRestart() throws Exception {
        this.doAddDestination();
        this.doRemoveDestination();
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = this.createBroker();
        this.doCheckRemoveActionAfterRestart();
    }

    public void doAddDestination() throws Exception {
        ActiveMQDestination[] list;
        boolean res = false;
        ActiveMQDestination amqDestination = ActiveMQDestination.createDestination((String)destinationName, (byte)this.destinationType);
        this.broker.getRegionBroker().addDestination(this.broker.getAdminConnectionContext(), amqDestination, true);
        for (ActiveMQDestination element : list = this.broker.getRegionBroker().getDestinations()) {
            Destination destination = this.broker.getDestination(element);
            if (!destination.getActiveMQDestination().getPhysicalName().equals(destinationName)) continue;
            res = true;
            break;
        }
        DestinationRemoveRestartTest.assertTrue((String)"Adding destination Failed", (boolean)res);
    }

    public void doRemoveDestination() throws Exception {
        ActiveMQDestination[] list;
        boolean res = true;
        this.broker.removeDestination(ActiveMQDestination.createDestination((String)destinationName, (byte)this.destinationType));
        for (ActiveMQDestination element : list = this.broker.getRegionBroker().getDestinations()) {
            Destination destination = this.broker.getDestination(element);
            if (!destination.getActiveMQDestination().getPhysicalName().equals(destinationName)) continue;
            res = false;
            break;
        }
        DestinationRemoveRestartTest.assertTrue((String)"Removing destination Failed", (boolean)res);
    }

    public void doCheckRemoveActionAfterRestart() throws Exception {
        ActiveMQDestination[] list;
        boolean res = true;
        for (ActiveMQDestination element : list = this.broker.getRegionBroker().getDestinations()) {
            Destination destination = this.broker.getDestination(element);
            if (!destination.getActiveMQDestination().getPhysicalName().equals(destinationName)) continue;
            res = false;
            break;
        }
        DestinationRemoveRestartTest.assertTrue((String)"The removed destination is reloaded after restart !", (boolean)res);
    }

    public static Test suite() {
        return DestinationRemoveRestartTest.suite(DestinationRemoveRestartTest.class);
    }
}

