/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import java.util.ArrayList;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.jmx.ManagedRegionBroker;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationWildcardTest {
    protected static final String DESTNAME = "DomainA.DomainB.TestMeA.TestMeB.Prioritised.Queue";
    protected static final int QUEUE_LIMIT = 5000000;
    protected static Logger LOG = LoggerFactory.getLogger(DestinationWildcardTest.class);
    private BrokerService broker = null;

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setDeleteAllMessagesOnStartup(true);
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("Shutting down");
        if (this.broker != null && this.broker.isStarted()) {
            LOG.info("Broker still running, stopping it now.");
            this.broker.stop();
        } else {
            LOG.info("Broker not running, nothing to shutdown.");
        }
    }

    @Test
    public void testDestinationWildcardThreeEntries() throws Exception {
        LOG.info("testDestinationWildcard() called.");
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry e1 = new PolicyEntry();
        e1.setDestination((ActiveMQDestination)new ActiveMQQueue(DESTNAME));
        e1.setMemoryLimit(5000000L);
        e1.setPrioritizedMessages(true);
        entries.add(e1);
        PolicyEntry e2 = new PolicyEntry();
        e2.setDestination((ActiveMQDestination)new ActiveMQQueue("DomainA.DomainB.*.*.Prioritised.Queue"));
        e2.setMemoryLimit(3000000L);
        e2.setPrioritizedMessages(false);
        entries.add(e2);
        PolicyEntry e3 = new PolicyEntry();
        e3.setDestination((ActiveMQDestination)new ActiveMQQueue("DomainA.DomainB.>"));
        e3.setMemoryLimit(3000000L);
        e3.setPrioritizedMessages(false);
        entries.add(e3);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setPolicyEntries(entries);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.start();
        this.broker.waitUntilStarted();
        Assert.assertNotNull((Object)this.broker);
        ManagedRegionBroker rb = (ManagedRegionBroker)this.broker.getRegionBroker();
        Queue queue = (Queue)rb.addDestination(new ConnectionContext(), (ActiveMQDestination)new ActiveMQQueue(DESTNAME), true);
        Assert.assertTrue((String)"PolicyEntry should have priorityMessages enabled for destination DomainA.DomainB.TestMeA.TestMeB.Prioritised.Queue", (boolean)queue.isPrioritizedMessages());
        long limit = queue.getMemoryUsage().getLimit();
        LOG.info("MemoryLimit of {}: expected: 5242880, actual: {}", (Object)DESTNAME, (Object)limit);
        Assert.assertEquals((String)"Memory limit is expected to be 5000000 for this destination, but does not match.", (long)5000000L, (long)limit);
    }

    @Test
    public void testDestinationWildcardTwoEntries() throws Exception {
        LOG.info("testDestinationWildcard() called.");
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry e1 = new PolicyEntry();
        e1.setDestination((ActiveMQDestination)new ActiveMQQueue("DomainA.DomainB.*.*.Prioritised.Queue"));
        e1.setMemoryLimit(5000000L);
        e1.setPrioritizedMessages(true);
        entries.add(e1);
        PolicyEntry e2 = new PolicyEntry();
        e2.setDestination((ActiveMQDestination)new ActiveMQQueue("DomainA.DomainB.>"));
        e2.setMemoryLimit(3000000L);
        e2.setPrioritizedMessages(false);
        entries.add(e2);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setPolicyEntries(entries);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.start();
        this.broker.waitUntilStarted();
        Assert.assertNotNull((Object)this.broker);
        ManagedRegionBroker rb = (ManagedRegionBroker)this.broker.getRegionBroker();
        Queue queue = (Queue)rb.addDestination(new ConnectionContext(), (ActiveMQDestination)new ActiveMQQueue(DESTNAME), true);
        Assert.assertTrue((String)"PolicyEntry should have priorityMessages enabled for destination DomainA.DomainB.TestMeA.TestMeB.Prioritised.Queue", (boolean)queue.isPrioritizedMessages());
        long limit = queue.getMemoryUsage().getLimit();
        LOG.info("MemoryLimit of {}: expected: 5242880, actual: {}", (Object)DESTNAME, (Object)limit);
        Assert.assertEquals((String)"Memory limit is expected to be 5000000 for this destination, but does not match.", (long)5000000L, (long)limit);
    }

    @Test
    public void testDestinationWildcardOneEntry() throws Exception {
        LOG.info("testDestinationWildcard2() called.");
        Assert.assertNotNull((Object)this.broker);
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry e1 = new PolicyEntry();
        e1.setDestination((ActiveMQDestination)new ActiveMQQueue("DomainA.DomainB.*.*.Prioritised.Queue"));
        e1.setMemoryLimit(5000000L);
        e1.setPrioritizedMessages(true);
        entries.add(e1);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setPolicyEntries(entries);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.start();
        this.broker.waitUntilStarted();
        ManagedRegionBroker rb = (ManagedRegionBroker)this.broker.getRegionBroker();
        Queue queue = (Queue)rb.addDestination(new ConnectionContext(), (ActiveMQDestination)new ActiveMQQueue(DESTNAME), true);
        Assert.assertTrue((String)"PolicyEntry should have priorityMessages enabled for destination DomainA.DomainB.TestMeA.TestMeB.Prioritised.Queue", (boolean)queue.isPrioritizedMessages());
        long limit = queue.getMemoryUsage().getLimit();
        LOG.info("MemoryLimit of {}: expected: 5000000, actual: {}", (Object)"DomainA", (Object)limit);
        Assert.assertEquals((String)"Memory limit is expected to be 5000000 for this destination, but does not match.", (long)5000000L, (long)limit);
    }
}

