/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.message.security;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.IOException;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.security.MessageAuthorizationPolicy;
import org.apache.activemq.spring.ConsumerBean;

public class MessageAuthenticationTest
extends EmbeddedBrokerTestSupport {
    private Connection connection;

    public void testSendInvalidMessage() throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.start();
        ConsumerBean messageList = new ConsumerBean();
        messageList.setVerbose(true);
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = new ActiveMQQueue("MyQueue");
        MessageConsumer c1 = session.createConsumer((Destination)destination);
        c1.setMessageListener((MessageListener)messageList);
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageAuthenticationTest.assertNotNull((Object)producer);
        producer.send(this.createMessage(session, "invalidBody", "myHeader", "xyz"));
        producer.send(this.createMessage(session, "validBody", "myHeader", "abc"));
        messageList.assertMessagesArrived(1);
        MessageAuthenticationTest.assertEquals((String)"validBody", (String)((TextMessage)messageList.flushMessages().get(0)).getText());
    }

    private Message createMessage(Session session, String body, String header, String value) throws JMSException {
        TextMessage msg = session.createTextMessage(body);
        msg.setStringProperty(header, value);
        return msg;
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(false);
        answer.setMessageAuthorizationPolicy(new MessageAuthorizationPolicy(){

            public boolean isAllowedToConsume(ConnectionContext context, org.apache.activemq.command.Message message) {
                try {
                    Object value = message.getProperty("myHeader");
                    return "abc".equals(value);
                }
                catch (IOException e) {
                    System.out.println("Caught: " + e);
                    e.printStackTrace();
                    return false;
                }
            }
        });
        answer.addConnector(this.bindAddress);
        return answer;
    }
}

