/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.HealthStatus;
import org.apache.activemq.broker.jmx.HealthViewMBean;
import org.apache.activemq.broker.jmx.MBeanTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthViewMBeanTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanTest.class);
    protected MBeanServer mbeanServer;
    protected String domain = "org.apache.activemq";

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:0";
        this.useTopic = false;
        super.setUp();
        this.mbeanServer = this.broker.getManagementContext().getMBeanServer();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(true);
        answer.setDeleteAllMessagesOnStartup(true);
        answer.getSystemUsage().getMemoryUsage().setLimit(0x4000000L);
        answer.getSystemUsage().getTempUsage().setLimit(0x4000000L);
        answer.getSystemUsage().getStoreUsage().setLimit(0x4000000L);
        answer.getSystemUsage().getJobSchedulerUsage().setLimit(0x4000000L);
        answer.setUseJmx(true);
        answer.setSchedulerSupport(true);
        answer.addConnector(this.bindAddress);
        return answer;
    }

    public void testHealthView() throws Exception {
        Connection connection = this.connectionFactory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        this.destination = this.createDestination();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        producer.setDeliveryMode(1);
        for (int i = 0; i < 60; ++i) {
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(new byte[0x100000]);
            producer.send((Message)message);
        }
        Thread.sleep(1000L);
        Object objectNameStr = this.broker.getBrokerObjectName().toString();
        objectNameStr = (String)objectNameStr + ",service=Health";
        ObjectName brokerName = this.assertRegisteredObjectName((String)objectNameStr);
        HealthViewMBean health = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerName, HealthViewMBean.class, true);
        List list = health.healthList();
        for (HealthStatus status : list) {
            LOG.info("Health status: {}", (Object)status);
        }
        HealthViewMBeanTest.assertEquals((int)2, (int)list.size());
        String healthStatus = health.healthStatus();
        String currentStatus = health.getCurrentStatus();
        HealthViewMBeanTest.assertEquals((String)healthStatus, (String)currentStatus);
    }

    protected ObjectName assertRegisteredObjectName(String name) throws MalformedObjectNameException, NullPointerException {
        ObjectName objectName = new ObjectName(name);
        if (this.mbeanServer.isRegistered(objectName)) {
            LOG.info("Bean Registered: " + objectName);
        } else {
            HealthViewMBeanTest.fail((String)("Could not find MBean!: " + objectName));
        }
        return objectName;
    }
}

