/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.blob;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.BlobMessage;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.activemq.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemBlobTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FilesystemBlobTest.class);
    private Connection connection;
    private final String tmpDir = System.getProperty("user.dir") + "/target/FilesystemBlobTest";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        String fileUrl = "file:///" + this.tmpDir.replaceAll("\\\\", "/");
        LOG.info("Using file: " + fileUrl);
        this.bindAddress = "vm://localhost?jms.blobTransferPolicy.defaultUploadUrl=" + fileUrl;
        this.connectionFactory = this.createConnectionFactory();
        this.connection = this.createConnection();
        this.connection.start();
    }

    public void testBlobFile() throws Exception {
        File file = File.createTempFile("amq-data-file-", ".dat");
        String content = "hello world " + System.currentTimeMillis();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.append(content);
        writer.close();
        ActiveMQSession session = (ActiveMQSession)this.connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)this.destination);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        BlobMessage message = session.createBlobMessage(file);
        producer.send((Message)message);
        Thread.sleep(1000L);
        Message msg = consumer.receive(1000L);
        FilesystemBlobTest.assertTrue((boolean)(msg instanceof ActiveMQBlobMessage));
        InputStream input = ((ActiveMQBlobMessage)msg).getInputStream();
        StringBuilder b = new StringBuilder();
        int i = input.read();
        while (i != -1) {
            b.append((char)i);
            i = input.read();
        }
        input.close();
        File uploaded = new File(this.tmpDir, msg.getJMSMessageID().toString().replace(":", "_"));
        FilesystemBlobTest.assertEquals((String)content, (String)b.toString());
        FilesystemBlobTest.assertTrue((boolean)uploaded.exists());
        ((ActiveMQBlobMessage)msg).deleteFile();
        FilesystemBlobTest.assertFalse((boolean)uploaded.exists());
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
        IOHelper.deleteFile((File)new File(this.tmpDir));
    }
}

