/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.DestinationSource;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RemoveDestinationTest {
    private static final String VM_BROKER_URL = "vm://localhost?create=false";
    BrokerService broker;

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(true);
        this.broker.getManagementContext().setCreateConnector(false);
        this.broker.setSchedulerSupport(false);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = null;
    }

    private Connection createConnection(boolean start) throws JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(VM_BROKER_URL);
        Connection conn = cf.createConnection();
        if (start) {
            conn.start();
        }
        return conn;
    }

    @Test(timeout=60000L)
    public void testRemoveQueue() throws Exception {
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.createConnection(true);
        final DestinationSource destinationSource = amqConnection.getDestinationSource();
        Session session = amqConnection.createSession(false, 1);
        Queue queue = session.createQueue("TEST.FOO");
        MessageProducer producer = session.createProducer((Destination)queue);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        TextMessage msg = session.createTextMessage("Hellow World");
        producer.send((Message)msg);
        Assert.assertNotNull((Object)consumer.receive(5000L));
        final ActiveMQQueue amqQueue = (ActiveMQQueue)queue;
        consumer.close();
        producer.close();
        session.close();
        Assert.assertTrue((String)"Destination discovered", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return destinationSource.getQueues().contains(amqQueue);
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(100L)));
        amqConnection.destroyDestination((ActiveMQDestination)queue);
        Assert.assertTrue((String)"Destination is removed", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return !destinationSource.getQueues().contains(amqQueue);
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(100L)));
    }

    @Test(timeout=60000L)
    public void testRemoveDestinationWithoutSubscriber() throws Exception {
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.createConnection(true);
        final DestinationSource destinationSource = amqConnection.getDestinationSource();
        Session session = amqConnection.createSession(false, 1);
        Topic topic = session.createTopic("TEST.FOO");
        MessageProducer producer = session.createProducer((Destination)topic);
        final int consumerCount = this.broker.getAdminView().getTopicSubscribers().length;
        MessageConsumer consumer = session.createConsumer((Destination)topic);
        TextMessage msg = session.createTextMessage("Hellow World");
        producer.send((Message)msg);
        Assert.assertNotNull((Object)consumer.receive(5000L));
        final ActiveMQTopic amqTopic = (ActiveMQTopic)topic;
        Assert.assertTrue((String)"Destination never discovered", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return destinationSource.getTopics().contains(amqTopic);
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(100L)));
        consumer.close();
        producer.close();
        session.close();
        Assert.assertTrue((String)"Subscriber still active", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return RemoveDestinationTest.this.broker.getAdminView().getTopicSubscribers().length == consumerCount;
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(100L)));
        amqConnection.destroyDestination((ActiveMQDestination)topic);
        Assert.assertTrue((String)"Destination still active", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return !destinationSource.getTopics().contains(amqTopic);
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(100L)));
        Assert.assertTrue((String)"Destination never unregistered", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return !RemoveDestinationTest.this.destinationPresentInAdminView(RemoveDestinationTest.this.broker, amqTopic);
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(100L)));
    }

    @Test(timeout=60000L)
    public void testRemoveDestinationWithSubscriber() throws Exception {
        ActiveMQConnection amqConnection = (ActiveMQConnection)this.createConnection(true);
        final DestinationSource destinationSource = amqConnection.getDestinationSource();
        Session session = amqConnection.createSession(false, 1);
        Topic topic = session.createTopic("TEST.FOO");
        MessageProducer producer = session.createProducer((Destination)topic);
        final int consumerCount = this.broker.getAdminView().getTopicSubscribers().length;
        MessageConsumer consumer = session.createConsumer((Destination)topic);
        TextMessage msg = session.createTextMessage("Hellow World");
        producer.send((Message)msg);
        Assert.assertNotNull((Object)consumer.receive(5000L));
        final ActiveMQTopic amqTopic = (ActiveMQTopic)topic;
        Assert.assertTrue((String)"Destination never registered", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return RemoveDestinationTest.this.destinationPresentInAdminView(RemoveDestinationTest.this.broker, amqTopic);
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(100L)));
        Assert.assertTrue((String)"Destination never discovered", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return destinationSource.getTopics().contains(amqTopic);
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(100L)));
        try {
            amqConnection.destroyDestination((ActiveMQDestination)topic);
            Assert.fail((String)"expect exception on destroy if comsumer present");
        }
        catch (JMSException expected) {
            Assert.assertTrue((expected.getMessage().indexOf(amqTopic.getTopicName()) != -1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"Destination never registered", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return RemoveDestinationTest.this.destinationPresentInAdminView(RemoveDestinationTest.this.broker, amqTopic);
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(100L)));
        Assert.assertTrue((String)"Destination never discovered", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return destinationSource.getTopics().contains(amqTopic);
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(100L)));
        consumer.close();
        producer.close();
        session.close();
        Assert.assertTrue((String)"Subscriber still active", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return RemoveDestinationTest.this.broker.getAdminView().getTopicSubscribers().length == consumerCount;
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(100L)));
        amqConnection.destroyDestination((ActiveMQDestination)amqTopic);
        Assert.assertTrue((String)"Destination still active", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return !destinationSource.getTopics().contains(amqTopic);
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(100L)));
        Assert.assertTrue((String)"Destination never unregistered", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return !RemoveDestinationTest.this.destinationPresentInAdminView(RemoveDestinationTest.this.broker, amqTopic);
            }
        }, (long)TimeUnit.SECONDS.toMillis(30L), (long)TimeUnit.MILLISECONDS.toMillis(100L)));
    }

    private boolean destinationPresentInAdminView(BrokerService broker2, ActiveMQTopic amqTopic) throws Exception {
        boolean found = false;
        for (ObjectName name : this.broker.getAdminView().getTopics()) {
            DestinationViewMBean proxy = (DestinationViewMBean)this.broker.getManagementContext().newProxyInstance(name, DestinationViewMBean.class, true);
            if (!proxy.getName().equals(amqTopic.getPhysicalName())) continue;
            found = true;
            break;
        }
        return found;
    }
}

