/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.ManagedTransportConnection;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectWithSameClientIDTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ReconnectWithSameClientIDTest.class);
    protected Connection connection;
    protected boolean transacted;
    protected int authMode = 1;
    public boolean useFailover = false;

    public static Test suite() {
        return ReconnectWithSameClientIDTest.suite(ReconnectWithSameClientIDTest.class);
    }

    public void initCombosForTestReconnectMultipleTimesWithSameClientID() {
        this.addCombinationValues("useFailover", new Object[]{Boolean.FALSE, Boolean.TRUE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReconnectMultipleTimesWithSameClientID() throws Exception {
        final AtomicBoolean failed = new AtomicBoolean(false);
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)org.apache.logging.log4j.core.Logger.class.cast(LogManager.getLogger(ManagedTransportConnection.class));
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                if (event.getMessage().getFormattedMessage().startsWith("Failed to register MBean")) {
                    LOG.info("received unexpected log message: " + event.getMessage());
                    failed.set(true);
                }
            }
        };
        appender.start();
        logger.get().addAppender((Appender)appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        logger.addAppender((Appender)appender);
        try {
            this.connection = this.connectionFactory.createConnection();
            this.useConnection(this.connection);
            for (int i = 1; i < 11; ++i) {
                try (Connection connection2 = this.connectionFactory.createConnection();){
                    this.useConnection(connection2);
                    ReconnectWithSameClientIDTest.fail((String)("Should have thrown InvalidClientIDException on attempt" + i));
                    continue;
                }
            }
            this.connection.close();
            this.connection = this.connectionFactory.createConnection();
            this.useConnection(this.connection);
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
        ReconnectWithSameClientIDTest.assertFalse((String)"failed on unexpected log event", (boolean)failed.get());
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory((this.useFailover ? "failover:" : "") + ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:0";
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    protected void useConnection(Connection connection) throws JMSException {
        connection.setClientID("foo");
        connection.start();
    }
}

