/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.test.JmsTopicSendReceiveTest;

public class JmsTopicWildcardSendReceiveTest
extends JmsTopicSendReceiveTest {
    private String destination1String = "TEST.ONE.ONE";
    private String destination2String = "TEST.ONE.ONE.ONE";
    private String destination3String = "TEST.ONE.TWO";
    private String destination4String = "TEST.TWO.ONE";

    @Override
    protected void setUp() throws Exception {
        this.topic = true;
        this.durable = false;
        this.deliveryMode = 1;
        super.setUp();
    }

    @Override
    protected String getConsumerSubject() {
        return "FOO.>";
    }

    @Override
    protected String getProducerSubject() {
        return "FOO.BAR.HUMBUG";
    }

    public void testReceiveWildcardTopicEndAsterisk() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination1 = (ActiveMQDestination)session.createTopic(this.destination1String);
        ActiveMQDestination destination3 = (ActiveMQDestination)session.createTopic(this.destination3String);
        Message m = null;
        MessageConsumer consumer = null;
        String text = null;
        ActiveMQDestination destination6 = (ActiveMQDestination)session.createTopic("TEST.ONE.*");
        consumer = session.createConsumer((Destination)destination6);
        this.sendMessage(session, (Destination)destination1, this.destination1String);
        this.sendMessage(session, (Destination)destination3, this.destination3String);
        m = consumer.receive(1000L);
        JmsTopicWildcardSendReceiveTest.assertNotNull((Object)m);
        text = ((TextMessage)m).getText();
        if (!text.equals(this.destination1String) && !text.equals(this.destination3String)) {
            JmsTopicWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        m = consumer.receive(1000L);
        JmsTopicWildcardSendReceiveTest.assertNotNull((Object)m);
        text = ((TextMessage)m).getText();
        if (!text.equals(this.destination1String) && !text.equals(this.destination3String)) {
            JmsTopicWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        JmsTopicWildcardSendReceiveTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void testReceiveWildcardTopicEndGreaterThan() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination1 = (ActiveMQDestination)session.createTopic(this.destination1String);
        ActiveMQDestination destination2 = (ActiveMQDestination)session.createTopic(this.destination2String);
        ActiveMQDestination destination3 = (ActiveMQDestination)session.createTopic(this.destination3String);
        Message m = null;
        MessageConsumer consumer = null;
        String text = null;
        ActiveMQDestination destination7 = (ActiveMQDestination)session.createTopic("TEST.ONE.>");
        consumer = session.createConsumer((Destination)destination7);
        this.sendMessage(session, (Destination)destination1, this.destination1String);
        this.sendMessage(session, (Destination)destination2, this.destination2String);
        this.sendMessage(session, (Destination)destination3, this.destination3String);
        m = consumer.receive(1000L);
        JmsTopicWildcardSendReceiveTest.assertNotNull((Object)m);
        text = ((TextMessage)m).getText();
        if (!(text.equals(this.destination1String) || text.equals(this.destination2String) || text.equals(this.destination3String))) {
            JmsTopicWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        m = consumer.receive(1000L);
        JmsTopicWildcardSendReceiveTest.assertNotNull((Object)m);
        if (!(text.equals(this.destination1String) || text.equals(this.destination2String) || text.equals(this.destination3String))) {
            JmsTopicWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        m = consumer.receive(1000L);
        JmsTopicWildcardSendReceiveTest.assertNotNull((Object)m);
        if (!(text.equals(this.destination1String) || text.equals(this.destination2String) || text.equals(this.destination3String))) {
            JmsTopicWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        JmsTopicWildcardSendReceiveTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void testReceiveWildcardTopicMidAsterisk() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination1 = (ActiveMQDestination)session.createTopic(this.destination1String);
        ActiveMQDestination destination4 = (ActiveMQDestination)session.createTopic(this.destination4String);
        Message m = null;
        MessageConsumer consumer = null;
        String text = null;
        ActiveMQDestination destination8 = (ActiveMQDestination)session.createTopic("TEST.*.ONE");
        consumer = session.createConsumer((Destination)destination8);
        this.sendMessage(session, (Destination)destination1, this.destination1String);
        this.sendMessage(session, (Destination)destination4, this.destination4String);
        m = consumer.receive(1000L);
        JmsTopicWildcardSendReceiveTest.assertNotNull((Object)m);
        text = ((TextMessage)m).getText();
        if (!text.equals(this.destination1String) && !text.equals(this.destination4String)) {
            JmsTopicWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        m = consumer.receive(1000L);
        JmsTopicWildcardSendReceiveTest.assertNotNull((Object)m);
        text = ((TextMessage)m).getText();
        if (!text.equals(this.destination1String) && !text.equals(this.destination4String)) {
            JmsTopicWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        JmsTopicWildcardSendReceiveTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void testReceiveWildcardTopicMatchDoubleWildcard() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination1 = (ActiveMQDestination)session.createTopic("a.*.>.>");
        ActiveMQDestination destination2 = (ActiveMQDestination)session.createTopic("a.b");
        Message m = null;
        MessageConsumer consumer = null;
        String text = null;
        consumer = session.createConsumer((Destination)destination1);
        this.sendMessage(session, (Destination)destination2, this.destination3String);
        m = consumer.receive(1000L);
        JmsTopicWildcardSendReceiveTest.assertNotNull((Object)m);
        text = ((TextMessage)m).getText();
        if (!text.equals(this.destination1String) && !text.equals(this.destination3String)) {
            JmsTopicWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        JmsTopicWildcardSendReceiveTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void testReceiveWildcardTopicMatchSinglePastTheEndWildcard() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination1 = (ActiveMQDestination)session.createTopic("a.>");
        ActiveMQDestination destination2 = (ActiveMQDestination)session.createTopic("a");
        Message m = null;
        MessageConsumer consumer = null;
        String text = null;
        consumer = session.createConsumer((Destination)destination1);
        this.sendMessage(session, (Destination)destination2, this.destination3String);
        m = consumer.receive(1000L);
        JmsTopicWildcardSendReceiveTest.assertNotNull((Object)m);
        text = ((TextMessage)m).getText();
        if (!text.equals(this.destination1String) && !text.equals(this.destination3String)) {
            JmsTopicWildcardSendReceiveTest.fail((String)("unexpected message:" + text));
        }
        JmsTopicWildcardSendReceiveTest.assertNull((Object)consumer.receiveNoWait());
    }

    private void sendMessage(Session session, Destination destination, String text) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        producer.send((Message)session.createTextMessage(text));
        producer.close();
    }
}

