/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import java.util.List;
import java.util.Vector;
import org.apache.activemq.test.TestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsTopicRequestReplyTest
extends TestSupport
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(JmsTopicRequestReplyTest.class);
    protected boolean useAsyncConsume;
    private Connection serverConnection;
    private Connection clientConnection;
    private MessageProducer replyProducer;
    private Session serverSession;
    private Destination requestDestination;
    private List<JMSException> failures = new Vector<JMSException>();
    private boolean dynamicallyCreateProducer;
    private String clientSideClientID;

    public void testSendAndReceive() throws Exception {
        this.clientConnection = this.createConnection();
        this.clientConnection.setClientID("ClientConnection:" + this.getSubject());
        Session session = this.clientConnection.createSession(false, 1);
        this.clientConnection.start();
        Destination replyDestination = this.createTemporaryDestination(session);
        this.clientSideClientID = this.clientConnection.getClientID();
        LOG.info("Both the clientID and destination clientID match properly: " + this.clientSideClientID);
        MessageProducer requestProducer = session.createProducer(this.requestDestination);
        MessageConsumer replyConsumer = session.createConsumer(replyDestination);
        TextMessage requestMessage = session.createTextMessage("Olivier");
        requestMessage.setJMSReplyTo(replyDestination);
        requestProducer.send((Message)requestMessage);
        LOG.info("Sent request.");
        LOG.info(requestMessage.toString());
        Message msg = replyConsumer.receive(5000L);
        if (msg instanceof TextMessage) {
            TextMessage replyMessage = (TextMessage)msg;
            LOG.info("Received reply.");
            LOG.info(replyMessage.toString());
            JmsTopicRequestReplyTest.assertEquals((String)"Wrong message content", (String)"Hello: Olivier", (String)replyMessage.getText());
        } else {
            JmsTopicRequestReplyTest.fail((String)"Should have received a reply by now");
        }
        replyConsumer.close();
        this.deleteTemporaryDestination(replyDestination);
        JmsTopicRequestReplyTest.assertEquals((String)("Should not have had any failures: " + this.failures), (int)0, (int)this.failures.size());
    }

    public void testSendAndReceiveWithDynamicallyCreatedProducer() throws Exception {
        this.dynamicallyCreateProducer = true;
        this.testSendAndReceive();
    }

    public void onMessage(Message message) {
        try {
            TextMessage requestMessage = (TextMessage)message;
            LOG.info("Received request.");
            LOG.info(requestMessage.toString());
            Destination replyDestination = requestMessage.getJMSReplyTo();
            TextMessage replyMessage = this.serverSession.createTextMessage("Hello: " + requestMessage.getText());
            replyMessage.setJMSCorrelationID(requestMessage.getJMSMessageID());
            if (this.dynamicallyCreateProducer) {
                this.replyProducer = this.serverSession.createProducer(replyDestination);
                this.replyProducer.send((Message)replyMessage);
            } else {
                this.replyProducer.send(replyDestination, (Message)replyMessage);
            }
            LOG.info("Sent reply.");
            LOG.info(replyMessage.toString());
        }
        catch (JMSException e) {
            this.onException(e);
        }
    }

    protected void syncConsumeLoop(MessageConsumer requestConsumer) {
        try {
            Message message = requestConsumer.receive(5000L);
            if (message != null) {
                this.onMessage(message);
            } else {
                LOG.error("No message received");
            }
        }
        catch (JMSException e) {
            this.onException(e);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.serverConnection = this.createConnection();
        this.serverConnection.setClientID("serverConnection:" + this.getSubject());
        this.serverSession = this.serverConnection.createSession(false, 1);
        this.replyProducer = this.serverSession.createProducer(null);
        this.requestDestination = this.createDestination(this.serverSession);
        final MessageConsumer requestConsumer = this.serverSession.createConsumer(this.requestDestination);
        if (this.useAsyncConsume) {
            requestConsumer.setMessageListener((MessageListener)this);
        } else {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    JmsTopicRequestReplyTest.this.syncConsumeLoop(requestConsumer);
                }
            });
            thread.start();
        }
        this.serverConnection.start();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.serverConnection.close();
        this.clientConnection.stop();
        this.clientConnection.close();
    }

    protected void onException(JMSException e) {
        LOG.info("Caught: " + e);
        e.printStackTrace();
        this.failures.add(e);
    }

    protected Destination createDestination(Session session) throws JMSException {
        if (this.topic) {
            return session.createTopic(this.getSubject());
        }
        return session.createQueue(this.getSubject());
    }

    protected Destination createTemporaryDestination(Session session) throws JMSException {
        if (this.topic) {
            return session.createTemporaryTopic();
        }
        return session.createTemporaryQueue();
    }

    protected void deleteTemporaryDestination(Destination dest) throws JMSException {
        if (this.topic) {
            ((TemporaryTopic)dest).delete();
        } else {
            ((TemporaryQueue)dest).delete();
        }
    }
}

