/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.vm.VMTransport;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsTempDestinationTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(JmsTempDestinationTest.class);
    private Connection connection;
    private ActiveMQConnectionFactory factory;
    protected List<Connection> connections = Collections.synchronizedList(new ArrayList());

    protected void setUp() throws Exception {
        this.factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.factory.setAlwaysSyncSend(true);
        this.connection = this.factory.createConnection();
        this.connections.add(this.connection);
    }

    protected void tearDown() throws Exception {
        Iterator<Connection> iter = this.connections.iterator();
        while (iter.hasNext()) {
            Connection conn = iter.next();
            try {
                conn.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            iter.remove();
        }
    }

    public void testTempDestOnlyConsumedByLocalConn() throws JMSException {
        this.connection.start();
        Session tempSession = this.connection.createSession(false, 1);
        TemporaryQueue queue = tempSession.createTemporaryQueue();
        MessageProducer producer = tempSession.createProducer((Destination)queue);
        producer.setDeliveryMode(1);
        TextMessage message = tempSession.createTextMessage("First");
        producer.send((Message)message);
        Connection otherConnection = this.factory.createConnection();
        this.connections.add(otherConnection);
        Session otherSession = otherConnection.createSession(false, 1);
        TemporaryQueue otherQueue = otherSession.createTemporaryQueue();
        MessageConsumer consumer = otherSession.createConsumer((Destination)otherQueue);
        Message msg = consumer.receive(3000L);
        JmsTempDestinationTest.assertNull((Object)msg);
        try {
            consumer = otherSession.createConsumer((Destination)queue);
            JmsTempDestinationTest.fail((String)"Send should fail since temp destination should be used from another connection");
        }
        catch (InvalidDestinationException e) {
            JmsTempDestinationTest.assertTrue((String)"failed to throw an exception", (boolean)true);
        }
        consumer = tempSession.createConsumer((Destination)queue);
        msg = consumer.receive(3000L);
        JmsTempDestinationTest.assertNotNull((Object)msg);
    }

    public void testTempQueueHoldsMessagesWithConsumers() throws JMSException {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue queue = session.createTemporaryQueue();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        this.connection.start();
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.setDeliveryMode(1);
        TextMessage message = session.createTextMessage("Hello");
        producer.send((Message)message);
        Message message2 = consumer.receive(1000L);
        JmsTempDestinationTest.assertNotNull((Object)message2);
        JmsTempDestinationTest.assertTrue((String)"Expected message to be a TextMessage", (boolean)(message2 instanceof TextMessage));
        JmsTempDestinationTest.assertTrue((String)("Expected message to be a '" + message.getText() + "'"), (boolean)((TextMessage)message2).getText().equals(message.getText()));
    }

    public void testTempQueueHoldsMessagesWithoutConsumers() throws JMSException {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue queue = session.createTemporaryQueue();
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.setDeliveryMode(1);
        TextMessage message = session.createTextMessage("Hello");
        producer.send((Message)message);
        this.connection.start();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message message2 = consumer.receive(3000L);
        JmsTempDestinationTest.assertNotNull((Object)message2);
        JmsTempDestinationTest.assertTrue((String)"Expected message to be a TextMessage", (boolean)(message2 instanceof TextMessage));
        JmsTempDestinationTest.assertTrue((String)("Expected message to be a '" + message.getText() + "'"), (boolean)((TextMessage)message2).getText().equals(message.getText()));
    }

    public void testTmpQueueWorksUnderLoad() throws JMSException {
        int count = 500;
        int dataSize = 1024;
        ArrayList<BytesMessage> list = new ArrayList<BytesMessage>(count);
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue queue = session.createTemporaryQueue();
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.setDeliveryMode(1);
        byte[] data = new byte[dataSize];
        for (int i = 0; i < count; ++i) {
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(data);
            message.setIntProperty("c", i);
            producer.send((Message)message);
            list.add(message);
        }
        this.connection.start();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        for (int i = 0; i < count; ++i) {
            Message message2 = consumer.receive(2000L);
            JmsTempDestinationTest.assertTrue((message2 != null ? 1 : 0) != 0);
            JmsTempDestinationTest.assertEquals((int)i, (int)message2.getIntProperty("c"));
            JmsTempDestinationTest.assertTrue((boolean)message2.equals(list.get(i)));
        }
    }

    public void testPublishFailsForClosedConnection() throws Exception {
        Connection tempConnection = this.factory.createConnection();
        this.connections.add(tempConnection);
        Session tempSession = tempConnection.createSession(false, 1);
        final TemporaryQueue queue = tempSession.createTemporaryQueue();
        Session session = this.connection.createSession(false, 1);
        this.connection.start();
        final ActiveMQConnection activeMQConnection = (ActiveMQConnection)this.connection;
        JmsTempDestinationTest.assertTrue((String)"creation advisory received in time with async dispatch", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return activeMQConnection.activeTempDestinations.containsKey(queue);
            }
        }));
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.setDeliveryMode(1);
        TextMessage message = session.createTextMessage("First");
        producer.send((Message)message);
        tempConnection.close();
        Thread.sleep(5000L);
        try {
            message = session.createTextMessage("Hello");
            producer.send((Message)message);
            JmsTempDestinationTest.fail((String)"Send should fail since temp destination should not exist anymore.");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testPublishFailsForDestroyedTempDestination() throws Exception {
        Connection tempConnection = this.factory.createConnection();
        this.connections.add(tempConnection);
        Session tempSession = tempConnection.createSession(false, 1);
        final TemporaryQueue queue = tempSession.createTemporaryQueue();
        Session session = this.connection.createSession(false, 1);
        this.connection.start();
        final ActiveMQConnection activeMQConnection = (ActiveMQConnection)this.connection;
        JmsTempDestinationTest.assertTrue((String)"creation advisory received in time with async dispatch", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return activeMQConnection.activeTempDestinations.containsKey(queue);
            }
        }));
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.setDeliveryMode(1);
        TextMessage message = session.createTextMessage("First");
        producer.send((Message)message);
        queue.delete();
        Thread.sleep(5000L);
        try {
            message = session.createTextMessage("Hello");
            producer.send((Message)message);
            JmsTempDestinationTest.fail((String)"Send should fail since temp destination should not exist anymore.");
        }
        catch (JMSException e) {
            JmsTempDestinationTest.assertTrue((String)"failed to throw an exception", (boolean)true);
        }
    }

    public void testDeleteDestinationWithSubscribersFails() throws JMSException {
        Connection connection = this.factory.createConnection();
        this.connections.add(connection);
        Session session = connection.createSession(false, 1);
        TemporaryQueue queue = session.createTemporaryQueue();
        connection.start();
        session.createConsumer((Destination)queue);
        try {
            queue.delete();
            JmsTempDestinationTest.fail((String)"Should fail as Subscribers are active");
        }
        catch (JMSException e) {
            JmsTempDestinationTest.assertTrue((String)"failed to throw an exception", (boolean)true);
        }
    }

    public void testSlowConsumerDoesNotBlockFastTempUsers() throws Exception {
        ActiveMQConnectionFactory advisoryConnFactory = new ActiveMQConnectionFactory("vm://localhost?asyncQueueDepth=20");
        Connection connection = advisoryConnFactory.createConnection();
        this.connections.add(connection);
        connection.start();
        final CountDownLatch done = new CountDownLatch(1);
        final AtomicBoolean ok = new AtomicBoolean(true);
        final AtomicBoolean first = new AtomicBoolean(true);
        VMTransport t = (VMTransport)((ActiveMQConnection)connection).getTransport().narrow(VMTransport.class);
        t.setTransportListener(new TransportListener(){

            public void onCommand(Object command) {
                if (first.compareAndSet(true, false)) {
                    try {
                        ok.set(done.await(35L, TimeUnit.SECONDS));
                        LOG.info("Done waiting: " + ok.get());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void onException(IOException error) {
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
        connection = this.factory.createConnection();
        this.connections.add(connection);
        ((ActiveMQConnection)connection).setWatchTopicAdvisories(false);
        connection.start();
        Session session = connection.createSession(false, 1);
        for (int i = 0; i < 2500; ++i) {
            TemporaryQueue queue = session.createTemporaryQueue();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            consumer.close();
            queue.delete();
        }
        LOG.info("Done with work: " + ok.get());
        done.countDown();
        JmsTempDestinationTest.assertTrue((String)"ok", (boolean)ok.get());
    }
}

