/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsSendReceiveWithMessageExpirationTest
extends TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JmsSendReceiveWithMessageExpirationTest.class);
    protected int messageCount = 100;
    protected String[] data;
    protected Session session;
    protected Destination consumerDestination;
    protected Destination producerDestination;
    protected boolean durable;
    protected int deliveryMode = 2;
    protected long timeToLive = 5000L;
    protected boolean verbose;
    protected Connection connection;

    protected void setUp() throws Exception {
        super.setUp();
        this.data = new String[this.messageCount];
        for (int i = 0; i < this.messageCount; ++i) {
            this.data[i] = "Text for message: " + i + " at " + new Date();
        }
        this.connectionFactory = this.createConnectionFactory();
        this.connection = this.createConnection();
        if (this.durable) {
            this.connection.setClientID(((Object)((Object)this)).getClass().getName());
        }
        this.session = this.connection.createSession(false, 1);
    }

    public void testConsumeExpiredQueue() throws Exception {
        MessageProducer producer = this.createProducer(this.timeToLive);
        this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
        this.producerDestination = this.session.createQueue(this.getProducerSubject());
        MessageConsumer consumer = this.createConsumer();
        this.connection.start();
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage message = this.session.createTextMessage(this.data[i]);
            message.setStringProperty("stringProperty", this.data[i]);
            message.setIntProperty("intProperty", i);
            if (this.verbose && LOG.isDebugEnabled()) {
                LOG.debug("About to send a queue message: " + (Message)message + " with text: " + this.data[i]);
            }
            producer.send(this.producerDestination, (Message)message);
        }
        Thread.sleep(this.timeToLive + 1000L);
        JmsSendReceiveWithMessageExpirationTest.assertNull((Object)consumer.receive(1000L));
    }

    public void testConsumeExpiredQueueAndDlq() throws Exception {
        Message received;
        TextMessage message;
        int i;
        MessageProducer producerNormal = this.createProducer(0L);
        MessageProducer producerExpire = this.createProducer(500L);
        this.consumerDestination = this.session.createQueue("ActiveMQ.DLQ");
        MessageConsumer dlqConsumer = this.createConsumer();
        this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
        this.producerDestination = this.session.createQueue(this.getProducerSubject());
        Connection consumerConnection = this.createConnection();
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setAll(10);
        ((ActiveMQConnection)consumerConnection).setPrefetchPolicy(prefetchPolicy);
        Session consumerSession = consumerConnection.createSession(false, 2);
        MessageConsumer consumer = consumerSession.createConsumer(this.consumerDestination);
        consumerConnection.start();
        this.connection.start();
        String msgBody = new String(new byte[20480]);
        for (i = 0; i < this.data.length; ++i) {
            message = this.session.createTextMessage(msgBody);
            producerExpire.send(this.producerDestination, (Message)message);
        }
        for (i = 0; i < this.data.length; ++i) {
            message = this.session.createTextMessage(msgBody);
            producerNormal.send(this.producerDestination, (Message)message);
        }
        Vector<Message> messages = new Vector<Message>();
        while ((received = consumer.receive(1000L)) != null) {
            messages.add(received);
            if (messages.size() == 1) {
                TimeUnit.SECONDS.sleep(1L);
            }
            received.acknowledge();
        }
        JmsSendReceiveWithMessageExpirationTest.assertEquals((String)"got all (normal plus one with ttl) messages", (int)(this.messageCount + 1), (int)messages.size());
        Vector<Message> dlqMessages = new Vector<Message>();
        while ((received = dlqConsumer.receive(1000L)) != null) {
            dlqMessages.add(received);
        }
        JmsSendReceiveWithMessageExpirationTest.assertEquals((String)"got dlq messages", (int)(this.data.length - 1), (int)dlqMessages.size());
        final DestinationStatistics view = JmsSendReceiveWithMessageExpirationTest.getDestinationStatistics(BrokerRegistry.getInstance().findFirst(), ActiveMQDestination.transform((Destination)this.consumerDestination));
        JmsSendReceiveWithMessageExpirationTest.assertTrue((String)"all inflight messages expired ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return view.getInflight().getCount() == 0L;
            }
        }));
        JmsSendReceiveWithMessageExpirationTest.assertEquals((String)"Wrong inFlightCount: ", (long)0L, (long)view.getInflight().getCount());
        LOG.info("Stats: received: " + messages.size() + ", messages: " + view.getMessages().getCount() + ", enqueues: " + view.getEnqueues().getCount() + ", dequeues: " + view.getDequeues().getCount() + ", dispatched: " + view.getDispatched().getCount() + ", inflight: " + view.getInflight().getCount() + ", expired: " + view.getExpired().getCount());
    }

    public void testConsumeQueue() throws Exception {
        MessageProducer producer = this.createProducer(0L);
        this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
        this.producerDestination = this.session.createQueue(this.getProducerSubject());
        MessageConsumer consumer = this.createConsumer();
        this.connection.start();
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage message = this.session.createTextMessage(this.data[i]);
            message.setStringProperty("stringProperty", this.data[i]);
            message.setIntProperty("intProperty", i);
            if (this.verbose && LOG.isDebugEnabled()) {
                LOG.debug("About to send a queue message: " + (Message)message + " with text: " + this.data[i]);
            }
            producer.send(this.producerDestination, (Message)message);
        }
        JmsSendReceiveWithMessageExpirationTest.assertNotNull((Object)consumer.receive(1000L));
    }

    public void testConsumeExpiredTopic() throws Exception {
        MessageProducer producer = this.createProducer(this.timeToLive);
        this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
        this.producerDestination = this.session.createTopic(this.getProducerSubject());
        MessageConsumer consumer = this.createConsumer();
        this.connection.start();
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage message = this.session.createTextMessage(this.data[i]);
            message.setStringProperty("stringProperty", this.data[i]);
            message.setIntProperty("intProperty", i);
            if (this.verbose && LOG.isDebugEnabled()) {
                LOG.debug("About to send a topic message: " + (Message)message + " with text: " + this.data[i]);
            }
            producer.send(this.producerDestination, (Message)message);
        }
        Thread.sleep(this.timeToLive + 1000L);
        JmsSendReceiveWithMessageExpirationTest.assertNull((Object)consumer.receive(1000L));
    }

    public void testConsumeTopic() throws Exception {
        MessageProducer producer = this.createProducer(0L);
        this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
        this.producerDestination = this.session.createTopic(this.getProducerSubject());
        MessageConsumer consumer = this.createConsumer();
        this.connection.start();
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage message = this.session.createTextMessage(this.data[i]);
            message.setStringProperty("stringProperty", this.data[i]);
            message.setIntProperty("intProperty", i);
            if (this.verbose && LOG.isDebugEnabled()) {
                LOG.debug("About to send a topic message: " + (Message)message + " with text: " + this.data[i]);
            }
            producer.send(this.producerDestination, (Message)message);
        }
        JmsSendReceiveWithMessageExpirationTest.assertNotNull((Object)consumer.receive(1000L));
    }

    protected MessageProducer createProducer(long timeToLive) throws JMSException {
        MessageProducer producer = this.session.createProducer(null);
        producer.setDeliveryMode(this.deliveryMode);
        producer.setTimeToLive(timeToLive);
        return producer;
    }

    protected MessageConsumer createConsumer() throws JMSException {
        if (this.durable) {
            LOG.info("Creating durable consumer");
            return this.session.createDurableSubscriber((Topic)this.consumerDestination, this.getName());
        }
        return this.session.createConsumer(this.consumerDestination);
    }

    protected void tearDown() throws Exception {
        LOG.info("Dumping stats...");
        LOG.info("Closing down connection");
        this.session.close();
        this.connection.close();
    }
}

