/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQXAConnectionFactoryTest;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsQueueBrowserTest
extends JmsTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQXAConnectionFactoryTest.class);
    public boolean isUseCache = false;

    public static Test suite() throws Exception {
        return JmsQueueBrowserTest.suite(JmsQueueBrowserTest.class);
    }

    public void testReceiveBrowseReceive() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.connection.start();
        Message[] outbound = new Message[]{session.createTextMessage("First Message"), session.createTextMessage("Second Message"), session.createTextMessage("Third Message")};
        while (consumer.receive(1000L) != null) {
        }
        producer.send(outbound[0]);
        producer.send(outbound[1]);
        producer.send(outbound[2]);
        JmsQueueBrowserTest.assertEquals((Object)outbound[0], (Object)consumer.receive(1000L));
        consumer.close();
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        JmsQueueBrowserTest.assertTrue((String)"should have received the second message", (boolean)enumeration.hasMoreElements());
        JmsQueueBrowserTest.assertEquals((Object)outbound[1], enumeration.nextElement());
        JmsQueueBrowserTest.assertTrue((String)"Should have received the third message", (boolean)enumeration.hasMoreElements());
        JmsQueueBrowserTest.assertEquals((Object)outbound[2], enumeration.nextElement());
        boolean tooMany = false;
        while (enumeration.hasMoreElements()) {
            LOG.info("Got extra message: " + ((TextMessage)enumeration.nextElement()).getText());
            tooMany = true;
        }
        JmsQueueBrowserTest.assertFalse((boolean)tooMany);
        browser.close();
        consumer = session.createConsumer((Destination)destination);
        JmsQueueBrowserTest.assertEquals((Object)outbound[1], (Object)consumer.receive(1000L));
        JmsQueueBrowserTest.assertEquals((Object)outbound[2], (Object)consumer.receive(1000L));
        consumer.close();
    }

    public void initCombosForTestBatchSendBrowseReceive() {
        this.addCombinationValues("isUseCache", new Boolean[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testBatchSendBrowseReceive() throws Exception {
        int i;
        int i2;
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.connection.start();
        TextMessage[] outbound = new TextMessage[10];
        for (i2 = 0; i2 < 10; ++i2) {
            outbound[i2] = session.createTextMessage(i2 + " Message");
        }
        while (consumer.receive(1000L) != null) {
        }
        consumer.close();
        for (i2 = 0; i2 < outbound.length; ++i2) {
            producer.send((Message)outbound[i2]);
        }
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        for (i = 0; i < outbound.length; ++i) {
            JmsQueueBrowserTest.assertTrue((String)"should have a", (boolean)enumeration.hasMoreElements());
            JmsQueueBrowserTest.assertEquals((Object)outbound[i], enumeration.nextElement());
        }
        browser.close();
        for (i = 0; i < outbound.length; ++i) {
            producer.send((Message)outbound[i]);
        }
        browser = session.createBrowser((Queue)destination);
        enumeration = browser.getEnumeration();
        for (int j = 0; j < 2; ++j) {
            for (int i3 = 0; i3 < outbound.length; ++i3) {
                JmsQueueBrowserTest.assertTrue((String)"should have a", (boolean)enumeration.hasMoreElements());
                JmsQueueBrowserTest.assertEquals((String)("j=" + j + ", i=" + i3), (String)outbound[i3].getText(), (String)((TextMessage)enumeration.nextElement()).getText());
            }
        }
        browser.close();
        consumer = session.createConsumer((Destination)destination);
        for (i = 0; i < outbound.length * 2; ++i) {
            JmsQueueBrowserTest.assertNotNull((String)("Got message: " + i), (Object)consumer.receive(2000L));
        }
        consumer.close();
    }

    public void initCombosForTestBatchSendJmxBrowseReceive() {
        this.addCombinationValues("isUseCache", new Boolean[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testBatchSendJmxBrowseReceive() throws Exception {
        int i;
        int i2;
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.connection.start();
        TextMessage[] outbound = new TextMessage[10];
        for (i2 = 0; i2 < 10; ++i2) {
            outbound[i2] = session.createTextMessage(i2 + " Message");
        }
        while (consumer.receive(1000L) != null) {
        }
        consumer.close();
        for (i2 = 0; i2 < outbound.length; ++i2) {
            producer.send((Message)outbound[i2]);
        }
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=TEST");
        LOG.info("Create QueueView MBean...");
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        long concount = proxy.getConsumerCount();
        LOG.info("Consumer Count :" + concount);
        long messcount = proxy.getQueueSize();
        LOG.info("current number of messages in the queue :" + messcount);
        CompositeData[] compdatalist = proxy.browse();
        if (compdatalist.length == 0) {
            JmsQueueBrowserTest.fail((String)"There is no message in the queue:");
        }
        String[] messageIDs = new String[compdatalist.length];
        for (int i3 = 0; i3 < compdatalist.length; ++i3) {
            CompositeData cdata = compdatalist[i3];
            if (i3 == 0) {
                LOG.info("Columns: " + cdata.getCompositeType().keySet());
            }
            messageIDs[i3] = (String)cdata.get("JMSMessageID");
            LOG.info("message " + i3 + " : " + cdata.values());
        }
        TabularData table = proxy.browseAsTable();
        LOG.info("Found tabular data: " + table);
        JmsQueueBrowserTest.assertTrue((String)"Table should not be empty!", (table.size() > 0 ? 1 : 0) != 0);
        JmsQueueBrowserTest.assertEquals((String)"Queue size", (long)outbound.length, (long)proxy.getQueueSize());
        JmsQueueBrowserTest.assertEquals((String)"Queue size", (int)outbound.length, (int)compdatalist.length);
        JmsQueueBrowserTest.assertEquals((String)"Queue size", (int)outbound.length, (int)table.size());
        LOG.info("Send another 10");
        for (i = 0; i < outbound.length; ++i) {
            producer.send((Message)outbound[i]);
        }
        LOG.info("Browse again");
        messcount = proxy.getQueueSize();
        LOG.info("current number of messages in the queue :" + messcount);
        compdatalist = proxy.browse();
        if (compdatalist.length == 0) {
            JmsQueueBrowserTest.fail((String)"There is no message in the queue:");
        }
        messageIDs = new String[compdatalist.length];
        for (i = 0; i < compdatalist.length; ++i) {
            CompositeData cdata = compdatalist[i];
            if (i == 0) {
                LOG.info("Columns: " + cdata.getCompositeType().keySet());
            }
            messageIDs[i] = (String)cdata.get("JMSMessageID");
            LOG.info("message " + i + " : " + cdata.values());
        }
        table = proxy.browseAsTable();
        LOG.info("Found tabular data: " + table);
        JmsQueueBrowserTest.assertTrue((String)"Table should not be empty!", (table.size() > 0 ? 1 : 0) != 0);
        JmsQueueBrowserTest.assertEquals((String)"Queue size", (long)(outbound.length * 2), (long)proxy.getQueueSize());
        JmsQueueBrowserTest.assertEquals((String)"Queue size", (int)(outbound.length * 2), (int)compdatalist.length);
        JmsQueueBrowserTest.assertEquals((String)"Queue size", (int)(outbound.length * 2), (int)table.size());
        consumer = session.createConsumer((Destination)destination);
        for (i = 0; i < outbound.length * 2; ++i) {
            JmsQueueBrowserTest.assertNotNull((String)("Got message: " + i), (Object)consumer.receive(2000L));
        }
        consumer.close();
    }

    public void testBrowseReceive() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.connection.start();
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        while (consumer.receive(1000L) != null) {
        }
        Message[] outbound = new Message[]{session.createTextMessage("First Message"), session.createTextMessage("Second Message"), session.createTextMessage("Third Message")};
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.send(outbound[0]);
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        JmsQueueBrowserTest.assertTrue((String)"should have received the first message", (boolean)enumeration.hasMoreElements());
        JmsQueueBrowserTest.assertEquals((Object)outbound[0], enumeration.nextElement());
        JmsQueueBrowserTest.assertEquals((Object)outbound[0], (Object)consumer.receive(1000L));
        consumer.close();
        browser.close();
        producer.close();
    }

    public void testLargeNumberOfMessages() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.connection.start();
        MessageProducer producer = session.createProducer((Destination)destination);
        int numberOfMessages = 4096;
        for (int i = 0; i < numberOfMessages; ++i) {
            producer.send((Message)session.createTextMessage("Message: " + i));
        }
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        JmsQueueBrowserTest.assertTrue((boolean)enumeration.hasMoreElements());
        int numberBrowsed = 0;
        while (enumeration.hasMoreElements()) {
            Message browsed = (Message)enumeration.nextElement();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Browsed Message [{}]", (Object)browsed.getJMSMessageID());
            }
            ++numberBrowsed;
        }
        System.out.println("Number browsed:  " + numberBrowsed);
        JmsQueueBrowserTest.assertEquals((int)numberOfMessages, (int)numberBrowsed);
        browser.close();
        producer.close();
    }

    public void testQueueBrowserWith2Consumers() throws Exception {
        Message m1;
        int i;
        int numMessages = 1000;
        this.connection.setAlwaysSyncSend(false);
        Session session = this.connection.createSession(false, 2);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        ActiveMQQueue destinationPrefetch10 = new ActiveMQQueue("TEST?jms.prefetchSize=10");
        ActiveMQQueue destinationPrefetch1 = new ActiveMQQueue("TEST?jms.prefetchsize=1");
        this.connection.start();
        ActiveMQConnection connection2 = (ActiveMQConnection)this.factory.createConnection(this.userName, this.password);
        connection2.start();
        this.connections.add(connection2);
        Session session2 = connection2.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destinationPrefetch10);
        while (consumer.receive(1000L) != null) {
        }
        for (int i2 = 0; i2 < 1000; ++i2) {
            TextMessage message = session.createTextMessage("Message: " + i2);
            producer.send((Message)message);
        }
        QueueBrowser browser = session2.createBrowser((Queue)destinationPrefetch1);
        Enumeration browserView = browser.getEnumeration();
        ArrayList<Message> messages = new ArrayList<Message>();
        for (i = 0; i < 1000; ++i) {
            m1 = consumer.receive(5000L);
            JmsQueueBrowserTest.assertNotNull((String)("m1 is null for index: " + i), (Object)m1);
            messages.add(m1);
        }
        for (i = 0; i < 1000 && browserView.hasMoreElements(); ++i) {
            m1 = (Message)messages.get(i);
            Message m2 = (Message)browserView.nextElement();
            JmsQueueBrowserTest.assertNotNull((String)("m2 is null for index: " + i), (Object)m2);
            JmsQueueBrowserTest.assertEquals((String)m1.getJMSMessageID(), (String)m2.getJMSMessageID());
        }
        JmsQueueBrowserTest.assertTrue((String)"got at least our expected minimum in the browser: ", (i > 200 ? 1 : 0) != 0);
        JmsQueueBrowserTest.assertFalse((String)"nothing left in the browser", (boolean)browserView.hasMoreElements());
        JmsQueueBrowserTest.assertNull((String)"consumer finished", (Object)consumer.receiveNoWait());
    }

    public void testBrowseClose() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.connection.start();
        TextMessage[] outbound = new TextMessage[]{session.createTextMessage("First Message"), session.createTextMessage("Second Message"), session.createTextMessage("Third Message")};
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        while (consumer.receive(1000L) != null) {
        }
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.send((Message)outbound[0]);
        producer.send((Message)outbound[1]);
        producer.send((Message)outbound[2]);
        QueueBrowser browser = session.createBrowser((Queue)destination);
        Enumeration enumeration = browser.getEnumeration();
        JmsQueueBrowserTest.assertEquals((Object)outbound[0], enumeration.nextElement());
        JmsQueueBrowserTest.assertEquals((Object)outbound[1], enumeration.nextElement());
        browser.close();
        TextMessage msg = (TextMessage)consumer.receive(1000L);
        JmsQueueBrowserTest.assertEquals((String)("Expected " + outbound[0].getText() + " but received " + msg.getText()), (Object)outbound[0], (Object)msg);
        msg = (TextMessage)consumer.receive(1000L);
        JmsQueueBrowserTest.assertEquals((String)("Expected " + outbound[1].getText() + " but received " + msg.getText()), (Object)outbound[1], (Object)msg);
        msg = (TextMessage)consumer.receive(1000L);
        JmsQueueBrowserTest.assertEquals((String)("Expected " + outbound[2].getText() + " but received " + msg.getText()), (Object)outbound[2], (Object)msg);
        consumer.close();
        producer.close();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService brokerService = super.createBroker();
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policyEntry = new PolicyEntry();
        policyEntry.setUseCache(this.isUseCache);
        policyEntry.setMaxBrowsePageSize(4096);
        policyMap.setDefaultEntry(policyEntry);
        brokerService.setDestinationPolicy(policyMap);
        return brokerService;
    }
}

