/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class JmsClientAckTest {
    @Rule
    public TestName name = new TestName();
    private Connection connection;

    @Before
    public void setUp() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false&broker.useJmx=false");
        this.connection = factory.createConnection();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    @Test(timeout=60000L)
    public void testAckedMessageAreConsumed() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(500L);
        Assert.assertNull((Object)msg);
        session.close();
    }

    @Test(timeout=60000L)
    public void testLastMessageAcked() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        producer.send((Message)session.createTextMessage("Hello2"));
        producer.send((Message)session.createTextMessage("Hello3"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        msg = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        msg = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(500L);
        Assert.assertNull((Object)msg);
        session.close();
    }

    @Test(timeout=60000L)
    public void testUnAckedMessageAreNotConsumedOnSessionClose() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        session.close();
        session = this.connection.createSession(false, 2);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(2000L);
        Assert.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
    }

    protected String getQueueName() {
        return this.getClass().getName() + "." + this.name.getMethodName();
    }
}

