/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.ResourceAllocationException;
import javax.jms.Session;
import javax.management.JMX;
import javax.management.MBeanServer;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerMBeanSupport;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MaxUncommittedCountExceededTest {
    public static final String DEFAULT_JMX_DOMAIN_NAME = "org.apache.activemq";
    public static final String DEFAULT_JMX_BROKER_NAME = "localhost";
    public static final String DEFAULT_JMS_USER = "admin";
    public static final String DEFAULT_JMS_PASS = "admin";
    private final boolean syncSend;
    private final String exceptionContains;
    protected ActiveMQConnectionFactory activemqConnectionFactory = null;
    protected BrokerService brokerService = null;
    @Rule
    public TestName testName = new TestName();
    protected Connection connection = null;
    protected Session session = null;
    protected MessageProducer messageProducer = null;
    protected String methodNameDestinationName = null;
    protected MBeanServer mbeanServer = null;
    protected QueueViewMBean queueViewMBean = null;

    @Parameterized.Parameters(name="syncSend={0}, exceptionContains={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true, "Can not send message on transaction with id: "}, {false, "has not been started."});
    }

    public MaxUncommittedCountExceededTest(boolean syncSend, String exceptionContains) {
        this.syncSend = syncSend;
        this.exceptionContains = exceptionContains;
    }

    @Before
    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setDeleteAllMessagesOnStartup(true);
        this.brokerService.setPersistent(true);
        this.brokerService.setUseJmx(true);
        this.brokerService.addConnector("tcp://localhost:0").setName("Default");
        this.brokerService.setBrokerName(DEFAULT_JMX_BROKER_NAME);
        this.brokerService.start();
        this.brokerService.waitUntilStarted(30000L);
        this.brokerService.deleteAllMessages();
        Assert.assertNotNull((Object)this.brokerService);
        this.activemqConnectionFactory = new ActiveMQConnectionFactory(this.brokerService.getTransportConnectorByScheme("tcp").getPublishableConnectString());
        this.connection = this.activemqConnectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(true, 0);
        this.methodNameDestinationName = "AMQ.TX." + MaxUncommittedCountExceededTest.cleanParameterizedMethodName(this.testName.getMethodName().toUpperCase());
        Queue queue = this.session.createQueue(this.methodNameDestinationName);
        this.messageProducer = this.session.createProducer((Destination)queue);
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.brokerService.getAdminView().addQueue(this.methodNameDestinationName);
        this.queueViewMBean = this.getQueueViewMBean((ActiveMQDestination)new ActiveMQQueue(this.methodNameDestinationName));
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.connection = null;
            }
        }
        this.methodNameDestinationName = null;
        this.activemqConnectionFactory = null;
        if (this.brokerService != null) {
            this.brokerService.deleteAllMessages();
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
    }

    protected static String cleanParameterizedMethodName(String methodName) {
        if (methodName == null || !methodName.contains("[") && !methodName.contains("]")) {
            return methodName;
        }
        String[] step1 = methodName.split("\\[", 2);
        String[] step2 = step1[1].split("\\]", 2);
        String[] step3 = step2[0].split(",", 16);
        return step1[0] + "." + step3[0].split("=", 2)[1] + "." + step3[1].split("=", 2)[1];
    }

    protected QueueViewMBean getQueueViewMBean(ActiveMQDestination destination) throws Exception {
        return JMX.newMBeanProxy(this.mbeanServer, BrokerMBeanSupport.createDestinationName((String)BrokerMBeanSupport.createBrokerObjectName((String)DEFAULT_JMX_DOMAIN_NAME, (String)DEFAULT_JMX_BROKER_NAME).toString(), (ActiveMQDestination)destination), QueueViewMBean.class);
    }

    protected void configureConnection(Connection connection, boolean syncSend) {
        if (syncSend) {
            ActiveMQConnection activemqConnection = (ActiveMQConnection)connection;
            activemqConnection.setAlwaysSyncSend(true);
            activemqConnection.setUseAsyncSend(false);
            activemqConnection.setProducerWindowSize(10);
        }
    }

    @Test
    public void testUncommittedCountExceeded() throws Exception {
        Assert.assertEquals((Object)0L, (Object)this.brokerService.getAdminView().getTotalMaxUncommittedExceededCount());
        Assert.assertEquals((Object)0L, (Object)this.queueViewMBean.getMaxUncommittedExceededCount());
        this.brokerService.setMaxUncommittedCount(10);
        boolean caught = false;
        JMSException caughtException = null;
        this.configureConnection(this.connection, this.syncSend);
        try {
            for (int i = 0; i < 20; ++i) {
                BytesMessage message = this.session.createBytesMessage();
                message.setIntProperty("IDX", i);
                this.messageProducer.send((Message)message);
            }
            if (!this.syncSend) {
                this.session.commit();
            }
        }
        catch (JMSException e) {
            if (this.syncSend) {
                Assert.assertTrue((boolean)(e instanceof ResourceAllocationException));
            }
            caught = true;
            caughtException = e;
        }
        Assert.assertTrue((boolean)caught);
        Assert.assertNotNull((Object)((Object)caughtException));
        Assert.assertTrue((boolean)caughtException.getMessage().contains(this.exceptionContains));
        Assert.assertEquals((Object)1L, (Object)this.brokerService.getAdminView().getTotalMaxUncommittedExceededCount());
        Assert.assertEquals((Object)1L, (Object)this.queueViewMBean.getMaxUncommittedExceededCount());
    }
}

