/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MessageDatabase;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;

public class EmptyTransactionTest
extends TestCase {
    private static final int CHECKPOINT_INTERVAL = 500;
    private BrokerService broker;

    public void testEmptyTransactionsCheckpoint() throws Exception {
        final AtomicBoolean hadRecovery = new AtomicBoolean(false);
        Logger logger = (Logger)Logger.class.cast(LogManager.getLogger(MessageDatabase.class));
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                if (event.getMessage().toString().contains("Recovering from the journal @")) {
                    hadRecovery.set(true);
                }
            }
        };
        appender.start();
        logger.get().addAppender((Appender)appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        logger.addAppender((Appender)appender);
        this.start(true);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue("QueueName"));
        producer.setDeliveryMode(1);
        this.sendMessage(session, producer);
        Thread.sleep(1000L);
        for (int i = 0; i < 5; ++i) {
            this.sendMessage(session, producer);
        }
        this.restart();
        EmptyTransactionTest.assertFalse((boolean)hadRecovery.get());
    }

    private void sendMessage(Session session, MessageProducer producer) throws JMSException {
        TextMessage m = session.createTextMessage("Hi");
        producer.send((Message)m);
        session.commit();
    }

    private void restart() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.start(false);
    }

    private void start(boolean deleteMessages) throws Exception {
        this.broker = new BrokerService();
        KahaDBPersistenceAdapter kahaDB = new KahaDBPersistenceAdapter();
        kahaDB.setCheckpointInterval(500L);
        this.broker.setPersistenceAdapter((PersistenceAdapter)kahaDB);
        this.broker.setPersistent(true);
        this.broker.setDeleteAllMessagesOnStartup(deleteMessages);
        this.broker.start();
        this.broker.waitUntilStarted();
    }
}

