/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.Usage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueMemoryAndStoreUsageCleanupTest {
    protected static final Logger LOG = LoggerFactory.getLogger(QueueMemoryAndStoreUsageCleanupTest.class);
    @Rule
    public TemporaryFolder dataFileDir = new TemporaryFolder(new File("target"));
    private BrokerService broker;
    private SystemUsage systemUsage;

    @Before
    public void setUpBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(true);
        this.broker.setDataDirectoryFile(this.dataFileDir.getRoot());
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.systemUsage = this.broker.getSystemUsage();
        this.startBroker();
    }

    protected void startBroker() throws Exception {
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test(timeout=30000L)
    public void testQueueMemoryAndStoreUsageCleanup() throws Exception {
        Field childrenField = Usage.class.getDeclaredField("children");
        childrenField.setAccessible(true);
        List memoryUsageChildren = (List)childrenField.get(this.systemUsage.getMemoryUsage());
        List storeUsageChildren = (List)childrenField.get(this.systemUsage.getStoreUsage());
        Destination queue1 = this.addDestination((ActiveMQDestination)new ActiveMQQueue("queue1"));
        Destination queue2 = this.addDestination((ActiveMQDestination)new ActiveMQQueue("queue2"));
        Destination queue3 = this.addDestination((ActiveMQDestination)new ActiveMQQueue("queue3"));
        Destination queue4 = this.addDestination((ActiveMQDestination)new ActiveMQQueue("queue4"));
        int beforeStopMemoryChildren = memoryUsageChildren.size();
        int beforeStopStoreChildren = storeUsageChildren.size();
        queue1.stop();
        queue2.stop();
        queue3.stop();
        queue4.stop();
        Assert.assertEquals((long)(beforeStopMemoryChildren - 4), (long)memoryUsageChildren.size());
        Assert.assertEquals((long)(beforeStopStoreChildren - 4), (long)storeUsageChildren.size());
    }

    private Destination addDestination(ActiveMQDestination destination) throws Exception {
        Destination dest = this.broker.getBroker().addDestination(this.broker.getAdminConnectionContext(), destination, false);
        dest.start();
        return dest;
    }
}

