/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Random;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.usage.StoreUsage;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.TempUsage;
import org.apache.activemq.util.StoreUtil;
import org.apache.activemq.util.Wait;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicDiskUsageLimitTest {
    protected static final Logger LOG = LoggerFactory.getLogger(PeriodicDiskUsageLimitTest.class);
    @Rule
    public TemporaryFolder dataFileDir = new TemporaryFolder(new File("target"));
    File testfile;
    private BrokerService broker;
    private PersistenceAdapter adapter;
    private TempUsage tempUsage;
    private StoreUsage storeUsage;
    protected URI brokerConnectURI;

    @Before
    public void setUpBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(false);
        this.broker.setPersistent(true);
        this.testfile = this.dataFileDir.newFile();
        this.broker.setDataDirectoryFile(this.dataFileDir.getRoot());
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.adapter = this.broker.getPersistenceAdapter();
        TransportConnector connector = this.broker.addConnector("tcp://0.0.0.0:0");
        connector.setName("tcp");
        this.brokerConnectURI = this.broker.getConnectorByName("tcp").getConnectUri();
        FileUtils.deleteQuietly((File)this.testfile);
        FileUtils.forceMkdir((File)this.adapter.getDirectory());
        FileUtils.forceMkdir((File)this.broker.getTempDataStore().getDirectory());
        SystemUsage systemUsage = this.broker.getSystemUsage();
        this.tempUsage = systemUsage.getTempUsage();
        this.storeUsage = systemUsage.getStoreUsage();
    }

    protected void startBroker() throws Exception {
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
        FileUtils.deleteQuietly((File)this.testfile);
    }

    @Test(timeout=90000L)
    public void testDiskUsageAdjustLower() throws Exception {
        this.setLimitMaxSpace();
        this.broker.setSchedulePeriodForDiskUsageCheck(2000);
        this.startBroker();
        this.assertRampDown();
    }

    @Test(timeout=90000L)
    public void testDiskUsageAdjustLowerAndHigherUsingPercent() throws Exception {
        this.tempUsage.setPercentLimit(this.getFreePercentage(this.broker.getTempDataStore().getDirectory()) + 5);
        this.storeUsage.setPercentLimit(this.getFreePercentage(this.adapter.getDirectory()) + 5);
        this.broker.setDiskUsageCheckRegrowThreshold(0x100000);
        this.broker.setSchedulePeriodForDiskUsageCheck(2000);
        this.startBroker();
        this.assertRampDown();
        final long storeLimit = this.broker.getSystemUsage().getStoreUsage().getLimit();
        final long tmpLimit = this.broker.getSystemUsage().getTempUsage().getLimit();
        FileUtils.deleteQuietly((File)this.testfile);
        Assert.assertTrue((String)"Store Usage should ramp up.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return PeriodicDiskUsageLimitTest.this.broker.getSystemUsage().getStoreUsage().getLimit() > storeLimit;
            }
        }, (long)15000L));
        Assert.assertTrue((String)"Temp Usage should ramp up.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return PeriodicDiskUsageLimitTest.this.broker.getSystemUsage().getTempUsage().getLimit() > tmpLimit;
            }
        }, (long)15000L));
    }

    @Test(timeout=60000L)
    public void testDiskLimitCheckNotSet() throws Exception {
        this.setLimitMaxSpace();
        this.startBroker();
        long originalDisk = this.broker.getSystemUsage().getStoreUsage().getLimit();
        long originalTmp = this.broker.getSystemUsage().getTempUsage().getLimit();
        this.writeTestFile(0x500000);
        Thread.sleep(5000L);
        Assert.assertEquals((long)originalDisk, (long)this.broker.getSystemUsage().getStoreUsage().getLimit());
        Assert.assertEquals((long)originalTmp, (long)this.broker.getSystemUsage().getTempUsage().getLimit());
    }

    @Test(timeout=60000L)
    public void testDiskLimitCheckNotSetUsingPercent() throws Exception {
        this.tempUsage.setPercentLimit(this.getFreePercentage(this.broker.getTempDataStore().getDirectory()) + 5);
        this.storeUsage.setPercentLimit(this.getFreePercentage(this.adapter.getDirectory()) + 5);
        this.startBroker();
        long originalDisk = this.broker.getSystemUsage().getStoreUsage().getLimit();
        long originalTmp = this.broker.getSystemUsage().getTempUsage().getLimit();
        this.writeTestFile(0x500000);
        Thread.sleep(5000L);
        Assert.assertEquals((long)originalDisk, (long)this.broker.getSystemUsage().getStoreUsage().getLimit());
        Assert.assertEquals((long)originalTmp, (long)this.broker.getSystemUsage().getTempUsage().getLimit());
    }

    @Test(timeout=60000L)
    public void testDiskUsageStaySame() throws Exception {
        this.tempUsage.setLimit(10000000L);
        this.storeUsage.setLimit(100000000L);
        this.broker.setSchedulePeriodForDiskUsageCheck(2000);
        this.startBroker();
        long originalDisk = this.broker.getSystemUsage().getStoreUsage().getLimit();
        long originalTmp = this.broker.getSystemUsage().getTempUsage().getLimit();
        this.writeTestFile(0x200000);
        Thread.sleep(5000L);
        Assert.assertEquals((long)originalDisk, (long)this.broker.getSystemUsage().getStoreUsage().getLimit());
        Assert.assertEquals((long)originalTmp, (long)this.broker.getSystemUsage().getTempUsage().getLimit());
    }

    @Test(timeout=60000L)
    public void testDiskUsageStaySameUsingPercent() throws Exception {
        int tempFreePercent = this.getFreePercentage(this.broker.getTempDataStore().getDirectory());
        int freePercent = this.getFreePercentage(this.adapter.getDirectory());
        if (freePercent >= 4 && tempFreePercent >= 4) {
            this.tempUsage.setPercentLimit(freePercent / 2);
            this.storeUsage.setPercentLimit(tempFreePercent / 2);
            this.broker.setSchedulePeriodForDiskUsageCheck(2000);
            this.startBroker();
            long originalDisk = this.broker.getSystemUsage().getStoreUsage().getLimit();
            long originalTmp = this.broker.getSystemUsage().getTempUsage().getLimit();
            this.writeTestFile(0x500000);
            Thread.sleep(5000L);
            Assert.assertEquals((long)originalDisk, (long)this.broker.getSystemUsage().getStoreUsage().getLimit());
            Assert.assertEquals((long)originalTmp, (long)this.broker.getSystemUsage().getTempUsage().getLimit());
        }
        LOG.info("Not running b/c there is less that 4% disk space, freePrecent:" + freePercent);
    }

    protected void assertRampDown() throws Exception {
        Assert.assertTrue((String)"Store Usage should ramp down", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                FileUtils.deleteQuietly((File)PeriodicDiskUsageLimitTest.this.testfile);
                final long originalDisk = PeriodicDiskUsageLimitTest.this.broker.getSystemUsage().getStoreUsage().getLimit();
                final long originalTmp = PeriodicDiskUsageLimitTest.this.broker.getSystemUsage().getTempUsage().getLimit();
                PeriodicDiskUsageLimitTest.this.writeTestFile(0xA00000);
                boolean storeUsageRampDown = Wait.waitFor((Wait.Condition)new Wait.Condition(){

                    public boolean isSatisified() throws Exception {
                        return PeriodicDiskUsageLimitTest.this.broker.getSystemUsage().getStoreUsage().getLimit() < originalDisk;
                    }
                }, (long)12000L);
                boolean tempUsageRampDown = false;
                if (storeUsageRampDown) {
                    tempUsageRampDown = Wait.waitFor((Wait.Condition)new Wait.Condition(){

                        public boolean isSatisified() throws Exception {
                            return PeriodicDiskUsageLimitTest.this.broker.getSystemUsage().getTempUsage().getLimit() < originalTmp;
                        }
                    }, (long)12000L);
                }
                return storeUsageRampDown && tempUsageRampDown;
            }
        }, (long)60000L));
    }

    protected void setLimitMaxSpace() {
        this.tempUsage.setLimit(this.broker.getTempDataStore().getDirectory().getUsableSpace());
        this.storeUsage.setLimit(this.adapter.getDirectory().getUsableSpace());
    }

    protected void writeTestFile(int size) throws IOException {
        byte[] data = new byte[size];
        Random rng = new Random();
        rng.nextBytes(data);
        try (FileOutputStream stream = new FileOutputStream(this.testfile);){
            IOUtils.write((byte[])data, (OutputStream)stream);
        }
    }

    protected int getFreePercentage(File directory) {
        File storeDir = StoreUtil.findParentDirectory((File)directory);
        return (int)((double)storeDir.getUsableSpace() / (double)storeDir.getTotalSpace() * 100.0);
    }
}

