/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.store.kahadb.AbstractKahaDBMessageStoreSizeTest;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.store.kahadb.MessageDatabase;
import org.apache.activemq.store.kahadb.disk.page.Transaction;
import org.junit.Assert;
import org.junit.Test;

public class KahaDBMessageStoreSizeTest
extends AbstractKahaDBMessageStoreSizeTest {
    @Override
    protected void createStore(boolean deleteAllMessages, String directory) throws Exception {
        KahaDBStore kahaDBStore = new KahaDBStore();
        this.store = kahaDBStore;
        kahaDBStore.setJournalMaxFileLength(524288);
        kahaDBStore.setDeleteAllMessages(deleteAllMessages);
        kahaDBStore.setDirectory(new File(directory));
        kahaDBStore.start();
        this.messageStore = this.store.createQueueMessageStore(this.destination);
        this.messageStore.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocationIndexMatchesOrderIndex() throws Exception {
        final KahaDBStore kahaDbStore = (KahaDBStore)this.store;
        this.writeMessages();
        kahaDbStore.indexLock.readLock().lock();
        try {
            long size = (Long)kahaDbStore.pageFile.tx().execute((Transaction.CallableClosure)new Transaction.CallableClosure<Long, IOException>(){

                public Long execute(Transaction tx) throws IOException {
                    long size = 0L;
                    MessageDatabase.StoredDestination sd = kahaDbStore.getStoredDestination(kahaDbStore.convert((ActiveMQDestination)KahaDBMessageStoreSizeTest.this.destination), tx);
                    Iterator iterator = sd.orderIndex.iterator(tx);
                    while (iterator.hasNext()) {
                        size += (long)((MessageDatabase.MessageKeys)((Map.Entry)iterator.next()).getValue()).location.getSize();
                    }
                    return size;
                }
            });
            Assert.assertEquals((String)"Order index size values don't match message size", (long)size, (long)this.messageStore.getMessageSize());
        }
        finally {
            kahaDbStore.indexLock.readLock().unlock();
        }
    }

    @Override
    protected String getVersion5Dir() {
        return "src/test/resources/org/apache/activemq/store/kahadb/MessageStoreTest/version5";
    }
}

