/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.statistics;

import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.statistics.AbstractInflightMessageSizeTest;
import org.apache.activemq.util.SubscriptionKey;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DurableSubscriptionInflightMessageSizeTest
extends AbstractInflightMessageSizeTest {
    public DurableSubscriptionInflightMessageSizeTest(int ackType, boolean optimizeAcknowledge, boolean useTopicSubscriptionInflightStats) {
        super(ackType, optimizeAcknowledge, useTopicSubscriptionInflightStats);
    }

    @Override
    protected MessageConsumer getMessageConsumer(String destName) throws JMSException {
        return this.session.createDurableSubscriber(this.getDestination(destName), "sub1");
    }

    @Override
    protected Subscription getSubscription() {
        return (Subscription)((Topic)this.amqDestination).getDurableTopicSubs().get(new SubscriptionKey("client1", "sub1"));
    }

    protected javax.jms.Topic getDestination(String destName) throws JMSException {
        return this.session.createTopic(destName);
    }

    @Override
    protected ActiveMQDestination getActiveMQDestination(String destName) {
        return new ActiveMQTopic(destName);
    }

    @Override
    @Test(timeout=60000L)
    public void testInflightMessageSizeRemoveDestination() throws Exception {
        Assume.assumeTrue((boolean)this.useTopicSubscriptionInflightStats);
        this.consumer.close();
        this.session.unsubscribe("sub1");
        super.testInflightMessageSizeRemoveDestination();
    }
}

