/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import javax.jms.Connection;
import javax.jms.JMSException;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.security.SimpleAuthenticationPluginTest;

public class SimpleAnonymousPluginTest
extends SimpleAuthenticationPluginTest {
    public static Test suite() {
        return SimpleAnonymousPluginTest.suite(SimpleAnonymousPluginTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SimpleAnonymousPluginTest.suite());
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        return this.createBroker("org/apache/activemq/security/simple-anonymous-broker.xml");
    }

    @Override
    public void testInvalidAuthentication() throws JMSException {
        Connection c2;
        try {
            c2 = this.factory.createConnection("user", "krap");
            this.connections.add(c2);
            c2.start();
            SimpleAnonymousPluginTest.fail((String)"Expected exception.");
        }
        catch (JMSException c2) {
            // empty catch block
        }
        try {
            c2 = this.factory.createConnection("userkrap", null);
            this.connections.add(c2);
            c2.start();
            SimpleAnonymousPluginTest.fail((String)"Expected exception.");
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void testAnonymousReceiveSucceeds() throws JMSException {
        this.doReceive(false);
    }

    public void testAnonymousReceiveFails() throws JMSException {
        this.doReceive(true);
    }

    public void testAnonymousSendFails() throws JMSException {
        this.doSend(true);
    }

    public void testAnonymousSendSucceeds() throws JMSException {
        this.doSend(false);
    }

    public void initCombosForTestAnonymousReceiveSucceeds() {
        this.addCombinationValues("userName", new Object[]{null});
        this.addCombinationValues("password", new Object[]{null});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("GUEST.BAR"), new ActiveMQTopic("GUEST.BAR")});
    }

    public void initCombosForTestAnonymousReceiveFails() {
        this.addCombinationValues("userName", new Object[]{null});
        this.addCombinationValues("password", new Object[]{null});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST"), new ActiveMQTopic("TEST"), new ActiveMQQueue("USERS.FOO"), new ActiveMQTopic("USERS.FOO")});
    }

    public void initCombosForTestAnonymousSendFails() {
        this.addCombinationValues("userName", new Object[]{null});
        this.addCombinationValues("password", new Object[]{null});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST"), new ActiveMQTopic("TEST"), new ActiveMQQueue("USERS.FOO"), new ActiveMQTopic("USERS.FOO")});
    }

    public void initCombosForTestAnonymousSendSucceeds() {
        this.addCombinationValues("userName", new Object[]{null});
        this.addCombinationValues("password", new Object[]{null});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("GUEST.BAR"), new ActiveMQTopic("GUEST.BAR")});
    }
}

