/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoSTest
extends JmsTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DoSTest.class);

    public void testInvalidAuthentication() throws Throwable {
        final AtomicBoolean done = new AtomicBoolean(false);
        Thread thread = new Thread(){
            Connection connection = null;

            @Override
            public void run() {
                for (int i = 0; i < 1000 && !done.get(); ++i) {
                    ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
                    try {
                        this.connection = factory.createConnection("bad", "krap");
                        this.connection.start();
                        TestCase.fail((String)"Expected exception.");
                        continue;
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        thread.start();
        TimeUnit.SECONDS.sleep(10L);
        LOG.info("trying genuine connection ...");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("failover:(tcp://127.0.0.1:61616)?useExponentialBackOff=false&reconnectDelay=10");
        Connection goodConnection = factory.createConnection("user", "password");
        goodConnection.start();
        goodConnection.close();
        LOG.info("giving up on DOS");
        done.set(true);
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        return this.createBroker("org/apache/activemq/security/dos-broker.xml");
    }

    protected BrokerService createBroker(String uri) throws Exception {
        LOG.info("Loading broker configuration from the classpath with URI: " + uri);
        return BrokerFactory.createBroker((URI)new URI("xbean:" + uri));
    }
}

