/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.network.BaseNetworkTest;
import org.junit.Assert;
import org.junit.Test;

public class NetworkRemoteUserPasswordTest
extends BaseNetworkTest {
    @Override
    protected void doSetUp(boolean deleteAllMessages) throws Exception {
        this.remoteBroker = this.createRemoteBroker();
        this.remoteBroker.setDeleteAllMessagesOnStartup(deleteAllMessages);
        this.remoteBroker.start();
        this.remoteBroker.waitUntilStarted();
        this.localBroker = this.createLocalBroker();
        this.localBroker.setDeleteAllMessagesOnStartup(deleteAllMessages);
        this.localBroker.start();
        this.localBroker.waitUntilStarted();
        URI localURI = this.localBroker.getVmConnectorURI();
        ActiveMQConnectionFactory fac = new ActiveMQConnectionFactory(localURI);
        fac.setAlwaysSyncSend(true);
        fac.setDispatchAsync(false);
        this.localConnection = fac.createConnection("userA", "passwordA");
        this.localConnection.setClientID("clientId");
        this.localConnection.start();
        URI remoteURI = this.remoteBroker.getVmConnectorURI();
        fac = new ActiveMQConnectionFactory(remoteURI);
        this.remoteConnection = fac.createConnection("userB", "passwordB");
        this.remoteConnection.setClientID("clientId");
        this.remoteConnection.start();
        this.localSession = this.localConnection.createSession(false, 1);
        this.remoteSession = this.remoteConnection.createSession(false, 1);
    }

    @Override
    protected String getRemoteBrokerURI() {
        return "org/apache/activemq/network/remoteBroker-authn.xml";
    }

    @Override
    protected String getLocalBrokerURI() {
        return "org/apache/activemq/network/localBroker-remote-userName.xml";
    }

    @Test
    public void testNetworkRemoteUserPassword() throws JMSException {
        this.sendTextMessage(this.localConnection, "include.test.foo", "This network message uses remoteUserName");
        this.verifyTextMessage(this.remoteConnection, "include.test.foo", "This network message uses remoteUserName", null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendTextMessage(Connection connection, String queueName, String textBody) throws JMSException {
        Session tmpSession = null;
        Object tmpProducer = null;
        try {
            tmpSession = connection.createSession(false, 1);
            MessageProducer tmpLocalProducer = tmpSession.createProducer((Destination)tmpSession.createQueue(queueName));
            tmpLocalProducer.send((Message)tmpSession.createTextMessage(textBody));
        }
        finally {
            if (tmpProducer != null) {
                tmpProducer.close();
            }
            if (tmpSession != null) {
                tmpSession.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyTextMessage(Connection connection, String queueName, String body, String property, String value, boolean propertyExists) throws JMSException {
        int maxLoops = 50;
        int loopCount = 0;
        boolean found = false;
        Session tmpSession = null;
        MessageConsumer tmpConsumer = null;
        try {
            tmpSession = connection.createSession(false, 1);
            tmpConsumer = tmpSession.createConsumer((Destination)tmpSession.createQueue(queueName));
            do {
                Message tmpMessage;
                if ((tmpMessage = tmpConsumer.receive(100L)) == null) continue;
                assert (TextMessage.class.isAssignableFrom(tmpMessage.getClass()));
                TextMessage tmpTextMessage = (TextMessage)TextMessage.class.cast(tmpMessage);
                Assert.assertEquals((Object)body, (Object)tmpTextMessage.getText());
                if (propertyExists) {
                    Assert.assertNotNull((Object)tmpTextMessage.getStringProperty(property));
                    Assert.assertEquals((Object)value, (Object)tmpTextMessage.getStringProperty(property));
                } else if (property != null) {
                    Assert.assertNull((Object)tmpTextMessage.getStringProperty(property));
                }
                found = true;
            } while (!found && ++loopCount < maxLoops);
            Assert.assertTrue((boolean)found);
        }
        finally {
            if (tmpConsumer != null) {
                tmpConsumer.close();
            }
            if (tmpSession != null) {
                tmpSession.close();
            }
        }
    }
}

