/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.joramtests;

import java.io.File;
import java.net.URI;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.objectweb.jtests.jms.admin.Admin;

public class ActiveMQAdmin
implements Admin {
    Context context;
    BrokerService broker;

    public ActiveMQAdmin() {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "org.eclipse.jetty.jndi.InitialContextFactory");
            env.put("java.naming.factory.url.pkgs", "org.eclipse.jetty.jndi");
            this.context = new InitialContext(env);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected BrokerService createBroker() throws Exception {
        return BrokerFactory.createBroker((URI)new URI("broker://()/localhost?persistent=false"));
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void startServer() throws Exception {
        if (System.getProperty("basedir") == null) {
            File file = new File(".");
            System.setProperty("basedir", file.getAbsolutePath());
        }
        this.broker = this.createBroker();
        this.broker.start();
    }

    public void stopServer() throws Exception {
        this.broker.stop();
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public Context createContext() throws NamingException {
        return this.context;
    }

    public void createQueue(String name) {
        try {
            this.context.bind(name, (Object)new ActiveMQQueue(name));
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void createTopic(String name) {
        try {
            this.context.bind(name, (Object)new ActiveMQTopic(name));
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteQueue(String name) {
        try {
            this.context.unbind(name);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteTopic(String name) {
        try {
            this.context.unbind(name);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void createConnectionFactory(String name) {
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
            factory.setNestedMapAndListEnabled(false);
            this.context.bind(name, (Object)factory);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteConnectionFactory(String name) {
        try {
            this.context.unbind(name);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public void createQueueConnectionFactory(String name) {
        this.createConnectionFactory(name);
    }

    public void createTopicConnectionFactory(String name) {
        this.createConnectionFactory(name);
    }

    public void deleteQueueConnectionFactory(String name) {
        this.deleteConnectionFactory(name);
    }

    public void deleteTopicConnectionFactory(String name) {
        this.deleteConnectionFactory(name);
    }
}

