/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms2;

import java.lang.management.ManagementFactory;
import javax.jms.Destination;
import javax.jms.XAConnection;
import org.apache.activemq.ActiveMQXAConnectionFactory;
import org.apache.activemq.jms2.ActiveMQJMS2TestBase;
import org.junit.After;
import org.junit.Before;

public abstract class ActiveMQJMS2XATestBase
extends ActiveMQJMS2TestBase {
    protected ActiveMQXAConnectionFactory activemqXAConnectionFactory = null;
    protected XAConnection xaConnection = null;

    @Override
    @Before
    public void setUp() throws Exception {
        this.activemqXAConnectionFactory = new ActiveMQXAConnectionFactory("vm://localhost?marshal=false&broker.persistent=false");
        this.xaConnection = this.activemqXAConnectionFactory.createXAConnection();
        activemqConnectionFactory = this.activemqXAConnectionFactory;
        this.connection = activemqConnectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.methodNameDestinationName = "AMQ.JMS2." + ActiveMQJMS2XATestBase.cleanParameterizedMethodName(this.testName.getMethodName().toUpperCase());
        this.messageProducer = this.session.createProducer((Destination)this.session.createQueue(this.methodNameDestinationName));
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        if (this.xaConnection != null) {
            try {
                this.xaConnection.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.xaConnection = null;
            }
        }
    }
}

