/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MessageDatabase;
import org.apache.activemq.util.Wait;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ6432Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ6432Test.class);
    private static final String QUEUE_NAME = "test.queue";
    private BrokerService broker;

    @Before
    public void setup() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setPersistent(true);
        KahaDBPersistenceAdapter kahaDB = new KahaDBPersistenceAdapter();
        kahaDB.setJournalMaxFileLength(262144);
        kahaDB.setCleanupInterval(500L);
        kahaDB.setCompactAcksAfterNoGC(1);
        kahaDB.setCompactAcksIgnoresStoreGrowth(true);
        this.broker.setPersistenceAdapter((PersistenceAdapter)kahaDB);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactedStoreUsageSuspendResume() throws Exception {
        final AtomicBoolean failed = new AtomicBoolean(false);
        File journalDataDir = ((KahaDBPersistenceAdapter)this.broker.getPersistenceAdapter()).getStore().getJournal().getDirectory();
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)org.apache.logging.log4j.core.Logger.class.cast(LogManager.getLogger(MessageDatabase.class));
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                if (event.getLevel().equals((Object)Level.WARN) && event.getMessage().getFormattedMessage().startsWith("Failed to load next journal")) {
                    LOG.info("received unexpected log message: " + event.getMessage().getFormattedMessage());
                    failed.set(true);
                }
            }
        };
        appender.start();
        logger.get().addAppender((Appender)appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        logger.addAppender((Appender)appender);
        try {
            ExecutorService sendExecutor = Executors.newSingleThreadExecutor();
            sendExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        AMQ6432Test.this.sendReceive(10000);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            sendExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        AMQ6432Test.this.sendLargeAndPurge(5000);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            sendExecutor.shutdown();
            sendExecutor.awaitTermination(10L, TimeUnit.MINUTES);
            TimeUnit.SECONDS.sleep(2L);
            Assert.assertTrue((String)"gc worked ok", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return ((KahaDBPersistenceAdapter)AMQ6432Test.this.broker.getPersistenceAdapter()).getStore().getJournal().getFileMap().size() < 3;
                }
            }));
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
        Assert.assertFalse((String)"failed on unexpected log event", (boolean)failed.get());
        this.sendReceive(500);
        Assert.assertTrue((String)"gc worked ok", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return ((KahaDBPersistenceAdapter)AMQ6432Test.this.broker.getPersistenceAdapter()).getStore().getJournal().getFileMap().size() < 2;
            }
        }));
        LOG.info("Files: " + Arrays.asList(journalDataDir.listFiles()));
        Assert.assertTrue((String)"Minimum data files in the mix", (journalDataDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("db-");
            }
        }).length == 1 ? 1 : 0) != 0);
    }

    private void sendReceive(int max) throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        factory.setAlwaysSyncSend(true);
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(QUEUE_NAME + max);
        MessageProducer producer = session.createProducer(null);
        producer.setDeliveryMode(2);
        BytesMessage message = session.createBytesMessage();
        message.writeBytes(new byte[10]);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        for (int i = 0; i < max; ++i) {
            producer.send((Destination)queue, (Message)message);
            consumer.receive(4000L);
        }
        connection.close();
    }

    private void sendLargeAndPurge(int max) throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        factory.setAlwaysSyncSend(true);
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        ActiveMQQueue toPurge = new ActiveMQQueue("test.queue-to-purge-" + max);
        MessageProducer producer = session.createProducer(null);
        producer.setDeliveryMode(2);
        BytesMessage message = session.createBytesMessage();
        message.writeBytes(new byte[1024]);
        for (int i = 0; i < max; ++i) {
            producer.send((Destination)toPurge, (Message)message);
        }
        connection.close();
        TimeUnit.SECONDS.sleep(1L);
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + toPurge.getQueueName());
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        proxy.purge();
    }
}

