/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.net.Socket;
import java.net.URI;
import javax.management.ObjectName;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.transport.stomp.StompConnection;
import org.apache.activemq.transport.stomp.StompFrame;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AMQ4126Test {
    protected BrokerService broker;
    protected String java_security_auth_login_config = "java.security.auth.login.config";
    protected String xbean = "xbean:";
    protected String confBase = "src/test/resources/org/apache/activemq/bugs/amq4126";
    protected String certBase = "src/test/resources/org/apache/activemq/security";
    protected String JaasStompSSLBroker_xml = "JaasStompSSLBroker.xml";
    protected StompConnection stompConnection = new StompConnection();
    private static final String destinationName = "TEST.QUEUE";
    protected String oldLoginConf = null;

    @Before
    public void before() throws Exception {
        if (System.getProperty(this.java_security_auth_login_config) != null) {
            this.oldLoginConf = System.getProperty(this.java_security_auth_login_config);
        }
        System.setProperty(this.java_security_auth_login_config, this.confBase + "/login.config");
        this.broker = BrokerFactory.createBroker((String)(this.xbean + this.confBase + "/" + this.JaasStompSSLBroker_xml));
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setUseJmx(true);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void after() throws Exception {
        this.broker.stop();
        if (this.oldLoginConf != null) {
            System.setProperty(this.java_security_auth_login_config, this.oldLoginConf);
        }
    }

    public Socket createSocket(String host, int port) throws Exception {
        System.setProperty("javax.net.ssl.trustStore", this.certBase + "/broker1.ks");
        System.setProperty("javax.net.ssl.trustStorePassword", "password");
        System.setProperty("javax.net.ssl.trustStoreType", "jks");
        System.setProperty("javax.net.ssl.keyStore", this.certBase + "/client.ks");
        System.setProperty("javax.net.ssl.keyStorePassword", "password");
        System.setProperty("javax.net.ssl.keyStoreType", "jks");
        SocketFactory factory = SSLSocketFactory.getDefault();
        return factory.createSocket(host, port);
    }

    public void stompConnectTo(String connectorName, String extraHeaders) throws Exception {
        String host = this.broker.getConnectorByName(connectorName).getConnectUri().getHost();
        int port = this.broker.getConnectorByName(connectorName).getConnectUri().getPort();
        this.stompConnection.open(this.createSocket(host, port));
        String extra = extraHeaders != null ? extraHeaders : "\n";
        this.stompConnection.sendFrame("CONNECT\n" + extra + "\n\u0000");
        StompFrame f = this.stompConnection.receive();
        TestCase.assertEquals((String)f.getBody(), (String)"CONNECTED", (String)f.getAction());
        this.stompConnection.close();
    }

    @Test
    public void testStompSSLWithUsernameAndPassword() throws Exception {
        this.stompConnectTo("stomp+ssl", "login:system\npasscode:manager\n");
    }

    @Test
    public void testStompSSLWithCertificate() throws Exception {
        this.stompConnectTo("stomp+ssl", null);
    }

    @Test
    public void testStompNIOSSLWithUsernameAndPassword() throws Exception {
        this.stompConnectTo("stomp+nio+ssl", "login:system\npasscode:manager\n");
    }

    @Test
    public void testStompNIOSSLWithCertificate() throws Exception {
        this.stompConnectTo("stomp+nio+ssl", null);
    }

    public void openwireConnectTo(String connectorName, String username, String password) throws Exception {
        URI brokerURI = this.broker.getConnectorByName(connectorName).getConnectUri();
        String uri = "ssl://" + brokerURI.getHost() + ":" + brokerURI.getPort() + "?socket.verifyHostName=false";
        ActiveMQSslConnectionFactory cf = new ActiveMQSslConnectionFactory(uri);
        cf.setTrustStore("org/apache/activemq/security/broker1.ks");
        cf.setTrustStorePassword("password");
        cf.setKeyStore("org/apache/activemq/security/client.ks");
        cf.setKeyStorePassword("password");
        ActiveMQConnection connection = null;
        connection = username != null || password != null ? (ActiveMQConnection)cf.createConnection(username, password) : (ActiveMQConnection)cf.createConnection();
        TestCase.assertNotNull((Object)connection);
        connection.start();
        connection.stop();
    }

    @Test
    public void testOpenwireSSLWithUsernameAndPassword() throws Exception {
        this.openwireConnectTo("openwire+ssl", "system", "manager");
    }

    @Test
    public void testOpenwireSSLWithCertificate() throws Exception {
        this.openwireConnectTo("openwire+ssl", null, null);
    }

    @Test
    public void testOpenwireNIOSSLWithUsernameAndPassword() throws Exception {
        this.openwireConnectTo("openwire+nio+ssl", "system", "mmanager");
    }

    @Test
    public void testOpenwireNIOSSLWithCertificate() throws Exception {
        this.openwireConnectTo("openwire+nio+ssl", null, null);
    }

    @Test
    public void testJmx() throws Exception {
        TestCase.assertFalse((boolean)this.findDestination(destinationName));
        this.broker.getAdminView().addQueue(destinationName);
        TestCase.assertTrue((boolean)this.findDestination(destinationName));
        this.broker.getAdminView().removeQueue(destinationName);
        TestCase.assertFalse((boolean)this.findDestination(destinationName));
    }

    private boolean findDestination(String name) throws Exception {
        ObjectName[] destinations;
        for (ObjectName destination : destinations = this.broker.getAdminView().getQueues()) {
            if (!destination.toString().contains(name)) continue;
            return true;
        }
        return false;
    }
}

