/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import java.io.File;
import java.util.Random;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.policy.MessageInterceptorStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.Message;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.util.ByteSequence;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MessageInterceptorStrategyMemoryUsageTest
extends TestSupport {
    BrokerService broker;
    ConnectionFactory factory;
    Connection connection;
    Session session;
    MessageProducer producer;
    QueueBrowser queueBrowser;

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        File testDataDir = new File("target/activemq-data/message-interceptor-strategy");
        this.broker.setDataDirectoryFile(testDataDir);
        this.broker.setUseJmx(true);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x4000000L);
        this.broker.setPersistenceAdapter((PersistenceAdapter)new MemoryPersistenceAdapter());
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.factory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString());
        this.connection = this.factory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
    }

    @After
    public void tearDown() throws Exception {
        if (this.producer != null) {
            this.producer.close();
        }
        this.session.close();
        this.connection.stop();
        this.connection.close();
        this.broker.stop();
    }

    @Test
    public void testMemoryUsageBodyIncrease() throws Exception {
        this.applyHeaderMessageInterceptor(0x100000);
        String queueName = "mis.bodySize.increase";
        Queue queue = this.createQueue(queueName);
        for (int i = 0; i < 10; ++i) {
            BytesMessage sendMessageP = this.session.createBytesMessage();
            byte[] origBody = new byte[1024];
            sendMessageP.writeBytes(origBody);
            this.producer.send((Destination)queue, (javax.jms.Message)sendMessageP);
        }
        QueueViewMBean queueViewMBean = this.getProxyToQueue(queueName);
        MessageInterceptorStrategyMemoryUsageTest.assertEquals((Object)10496000L, (Object)queueViewMBean.getMemoryUsageByteCount());
    }

    @Test
    public void testMemoryUsageBodyDecrease() throws Exception {
        this.applyHeaderMessageInterceptor(1024);
        String queueName = "mis.bodySize.decrease";
        Queue queue = this.createQueue(queueName);
        for (int i = 0; i < 10; ++i) {
            BytesMessage sendMessageP = this.session.createBytesMessage();
            byte[] origBody = new byte[0x100000];
            sendMessageP.writeBytes(origBody);
            this.producer.send((Destination)queue, (javax.jms.Message)sendMessageP);
        }
        QueueViewMBean queueViewMBean = this.getProxyToQueue(queueName);
        MessageInterceptorStrategyMemoryUsageTest.assertEquals((Object)20480L, (Object)queueViewMBean.getMemoryUsageByteCount());
    }

    private PolicyMap applyHeaderMessageInterceptor(final int bodySize) {
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        MessageInterceptorStrategy bodySizeMessageInterceptorStrategy = new MessageInterceptorStrategy(){

            public void process(ProducerBrokerExchange producerBrokerExchange, Message message) throws MessageFormatRuntimeException {
                if (bodySize > 0) {
                    try {
                        message.clearBody();
                    }
                    catch (JMSException e) {
                        TestCase.fail((String)e.getMessage());
                    }
                    byte[] newBody = new byte[bodySize];
                    new Random().nextBytes(newBody);
                    message.setContent(new ByteSequence(newBody));
                    message.storeContent();
                }
            }
        };
        defaultEntry.setMessageInterceptorStrategy(bodySizeMessageInterceptorStrategy);
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
        return policyMap;
    }

    private Queue createQueue(String queueName) throws Exception {
        Queue queue = this.session.createQueue(queueName);
        this.producer = this.session.createProducer((Destination)queue);
        return queue;
    }
}

