/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerTestSupport;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.broker.region.policy.PendingSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.VMPendingSubscriberMessageStoragePolicy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;

public class MessageExpirationTest
extends BrokerTestSupport {
    public ActiveMQDestination destination;
    public int deliveryMode = 1;
    public int prefetch;
    public byte destinationType = 1;
    public boolean durableConsumer;

    protected Message createMessage(ProducerInfo producerInfo, ActiveMQDestination destination, int deliveryMode, int timeToLive) {
        Message message = this.createMessage(producerInfo, destination, deliveryMode);
        long now = System.currentTimeMillis();
        message.setTimestamp(now);
        message.setExpiration(now + (long)timeToLive);
        return message;
    }

    public void initCombosForTestMessagesWaitingForUssageDecreaseExpire() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)5, (byte)6, (byte)1, (byte)2});
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        return broker;
    }

    @Override
    protected PolicyEntry getDefaultPolicy() {
        PolicyEntry policy = super.getDefaultPolicy();
        policy.setPendingSubscriberPolicy((PendingSubscriberMessageStoragePolicy)new VMPendingSubscriberMessageStoragePolicy());
        policy.setExpireMessagesPeriod(100L);
        return policy;
    }

    public void testMessagesWaitingForUsageDecreaseExpire() throws Exception {
        final StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        StubConnection connection2 = this.createConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        this.destination = this.createDestinationInfo(connection2, connectionInfo2, this.destinationType);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, this.destination);
        consumerInfo2.setPrefetchSize(1);
        connection2.request((Command)consumerInfo2);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(1L);
        final Message m1 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        final Message m2 = this.createMessage(producerInfo, this.destination, this.deliveryMode, 1000);
        final Message m3 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        final Message m4 = this.createMessage(producerInfo, this.destination, this.deliveryMode, 1000);
        new Thread(){

            @Override
            public void run() {
                try {
                    connection.send((Command)m1);
                    connection.send((Command)m2);
                    connection.send((Command)m3);
                    connection.send((Command)m4);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        Message m = this.receiveMessage(connection2);
        MessageExpirationTest.assertNotNull((Object)m);
        MessageExpirationTest.assertEquals((Object)m1.getMessageId(), (Object)m.getMessageId());
        this.assertNoMessagesLeft(connection);
        Thread.sleep(1500L);
        connection2.send((Command)this.createAck(consumerInfo2, m, 1, (byte)2));
        m = this.receiveMessage(connection2);
        MessageExpirationTest.assertNotNull((Object)m);
        MessageExpirationTest.assertEquals((Object)m3.getMessageId(), (Object)m.getMessageId());
        Thread.sleep(1500L);
        connection2.send((Command)this.createAck(consumerInfo2, m, 1, (byte)2));
        this.assertNoMessagesLeft(connection2);
        connection.send((Command)this.closeConnectionInfo(connectionInfo));
        connection.send((Command)this.closeConnectionInfo(connectionInfo2));
    }

    public void initCombosForTestMessagesInLongTransactionExpire() {
        this.addCombinationValues("deliveryMode", new Object[]{2, 1});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2, (byte)5, (byte)6});
    }

    public void testMessagesInLongTransactionExpire() throws Exception {
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection, connectionInfo, this.destinationType);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, this.destination);
        consumerInfo.setPrefetchSize(1000);
        connection.send((Command)consumerInfo);
        LocalTransactionId txid = this.createLocalTransaction(sessionInfo);
        connection.send((Command)this.createBeginTransaction(connectionInfo, (TransactionId)txid));
        Message m1 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        m1.setTransactionId((TransactionId)txid);
        connection.send((Command)m1);
        Message m = this.createMessage(producerInfo, this.destination, this.deliveryMode, 1000);
        m.setTransactionId((TransactionId)txid);
        connection.send((Command)m);
        Message m3 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        m3.setTransactionId((TransactionId)txid);
        connection.send((Command)m3);
        m = this.createMessage(producerInfo, this.destination, this.deliveryMode, 1000);
        m.setTransactionId((TransactionId)txid);
        connection.send((Command)m);
        Thread.sleep(1500L);
        connection.send((Command)this.createCommitTransaction1Phase(connectionInfo, (TransactionId)txid));
        m = this.receiveMessage(connection);
        MessageExpirationTest.assertNotNull((Object)m);
        MessageExpirationTest.assertEquals((Object)m1.getMessageId(), (Object)m.getMessageId());
        connection.send((Command)this.createAck(consumerInfo, m, 1, (byte)2));
        m = this.receiveMessage(connection);
        MessageExpirationTest.assertNotNull((Object)m);
        MessageExpirationTest.assertEquals((Object)m3.getMessageId(), (Object)m.getMessageId());
        connection.send((Command)this.createAck(consumerInfo, m, 1, (byte)2));
        this.assertNoMessagesLeft(connection);
        connection.send((Command)this.closeConnectionInfo(connectionInfo));
    }

    public void initCombosForTestMessagesInSubscriptionPendingListExpire() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2, (byte)5, (byte)6});
    }

    public void testMessagesInSubscriptionPendingListExpire() throws Exception {
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection, connectionInfo, this.destinationType);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, this.destination);
        consumerInfo.setPrefetchSize(1);
        connection.send((Command)consumerInfo);
        Message m1 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        connection.send((Command)m1);
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode, 1000));
        Message m3 = this.createMessage(producerInfo, this.destination, this.deliveryMode);
        connection.send((Command)m3);
        connection.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode, 1000));
        Message m = this.receiveMessage(connection);
        MessageExpirationTest.assertNotNull((Object)m);
        MessageExpirationTest.assertEquals((Object)m1.getMessageId(), (Object)m.getMessageId());
        this.assertNoMessagesLeft(connection);
        Thread.sleep(1500L);
        connection.send((Command)this.createAck(consumerInfo, m, 1, (byte)2));
        m = this.receiveMessage(connection);
        MessageExpirationTest.assertNotNull((Object)m);
        MessageExpirationTest.assertEquals((Object)m3.getMessageId(), (Object)m.getMessageId());
        connection.send((Command)this.createAck(consumerInfo, m, 1, (byte)2));
        this.assertNoMessagesLeft(connection);
        connection.send((Command)this.closeConnectionInfo(connectionInfo));
    }

    public static Test suite() {
        return MessageExpirationTest.suite(MessageExpirationTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MessageExpirationTest.suite());
    }
}

