/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.test.JmsTopicSendReceiveWithTwoConnectionsTest;
import org.apache.activemq.util.ServiceSupport;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class TwoBrokerTopicSendReceiveTest
extends JmsTopicSendReceiveWithTwoConnectionsTest {
    private static final Logger LOG = LoggerFactory.getLogger(TwoBrokerTopicSendReceiveTest.class);
    protected ActiveMQConnectionFactory sendFactory;
    protected ActiveMQConnectionFactory receiveFactory;
    protected HashMap<String, BrokerService> brokers = new HashMap();

    @Override
    protected void setUp() throws Exception {
        this.sendFactory = this.createSenderConnectionFactory();
        this.receiveFactory = this.createReceiverConnectionFactory();
        LOG.info("Waiting for brokers Initialize.");
        Thread.sleep(5000L);
        LOG.info("Brokers should be initialized by now.. starting test.");
        super.setUp();
    }

    protected ActiveMQConnectionFactory createReceiverConnectionFactory() throws JMSException {
        return this.createConnectionFactory("org/apache/activemq/usecases/receiver.xml", "receiver", "vm://receiver");
    }

    protected ActiveMQConnectionFactory createSenderConnectionFactory() throws JMSException {
        return this.createConnectionFactory("org/apache/activemq/usecases/sender.xml", "sender", "vm://sender");
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Iterator<BrokerService> iter = this.brokers.values().iterator();
        while (iter.hasNext()) {
            BrokerService broker = iter.next();
            ServiceSupport.dispose((Service)broker);
            iter.remove();
        }
    }

    @Override
    protected Connection createReceiveConnection() throws JMSException {
        return this.receiveFactory.createConnection();
    }

    @Override
    protected Connection createSendConnection() throws JMSException {
        return this.sendFactory.createConnection();
    }

    protected ActiveMQConnectionFactory createConnectionFactory(String config, String brokerName, String connectUrl) throws JMSException {
        try {
            BrokerFactoryBean brokerFactory = new BrokerFactoryBean((Resource)new ClassPathResource(config));
            brokerFactory.afterPropertiesSet();
            BrokerService broker = brokerFactory.getBroker();
            this.brokers.put(brokerName, broker);
            return new ActiveMQConnectionFactory(connectUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

