/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentDestinationCreationTest
extends TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ConcurrentDestinationCreationTest.class);
    BrokerService broker;

    protected void setUp() throws Exception {
        this.broker = this.createBroker();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.broker.stop();
    }

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString() + "?jms.watchTopicAdvisories=false&jms.closeTimeout=35000");
    }

    BrokerService createBroker() throws Exception {
        BrokerService service = new BrokerService();
        service.setDeleteAllMessagesOnStartup(true);
        service.setAdvisorySupport(false);
        service.setTransportConnectorURIs(new String[]{"tcp://localhost:0"});
        service.setPersistent(false);
        service.setUseJmx(false);
        service.start();
        return service;
    }

    public void testSendRateWithActivatingConsumers() throws Exception {
        final Vector exceptions = new Vector();
        int jobs = 50;
        int destinationCount = 10;
        final CountDownLatch allDone = new CountDownLatch(50);
        ExecutorService executor = Executors.newCachedThreadPool();
        for (int i = 0; i < 50; ++i) {
            if (i % 2 == 0 && i < 25) {
                executor.execute(new Runnable(){
                    final ConnectionFactory factory;
                    {
                        this.factory = ConcurrentDestinationCreationTest.this.createConnectionFactory();
                    }

                    @Override
                    public void run() {
                        try {
                            Connection connection = this.factory.createConnection();
                            connection.start();
                            Session session = connection.createSession(false, 1);
                            for (int j = 0; j < 500; ++j) {
                                MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue("Q." + j % 10));
                                producer.send(session.createMessage());
                            }
                            connection.close();
                            allDone.countDown();
                            LOG.info("Producers done!");
                        }
                        catch (Exception ignored) {
                            LOG.error("unexpected ", (Throwable)ignored);
                            exceptions.add(ignored);
                        }
                    }
                });
                continue;
            }
            executor.execute(new Runnable(){
                final ConnectionFactory factory;
                {
                    this.factory = ConcurrentDestinationCreationTest.this.createConnectionFactory();
                }

                @Override
                public void run() {
                    try {
                        Connection connection = this.factory.createConnection();
                        connection.start();
                        Session session = connection.createSession(false, 1);
                        for (int j = 0; j < 50; ++j) {
                            MessageConsumer consumer = session.createConsumer((Destination)new ActiveMQQueue("Q.>"));
                            consumer.receiveNoWait();
                        }
                        connection.close();
                        allDone.countDown();
                        LOG.info("Consumers done!");
                    }
                    catch (Exception ignored) {
                        LOG.error("unexpected ", (Throwable)ignored);
                        exceptions.add(ignored);
                    }
                }
            });
        }
        LOG.info("Waiting for completion");
        executor.shutdown();
        boolean success = allDone.await(30L, TimeUnit.SECONDS);
        if (!success) {
            ConcurrentDestinationCreationTest.dumpAllThreads((String)"hung");
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            LOG.info("Supports dead lock detection: " + bean.isSynchronizerUsageSupported());
            long[] threadIds = bean.findDeadlockedThreads();
            if (threadIds != null) {
                ThreadInfo[] infos;
                System.err.println("Dead locked threads....");
                for (ThreadInfo info : infos = bean.getThreadInfo(threadIds)) {
                    StackTraceElement[] stack = info.getStackTrace();
                    System.err.println(" " + info + ", stack size::" + stack.length);
                    for (StackTraceElement stackEntry : stack) {
                        System.err.println("   " + stackEntry);
                    }
                }
            }
        }
        ConcurrentDestinationCreationTest.assertTrue((String)"Finished on time", (boolean)success);
        ConcurrentDestinationCreationTest.assertTrue((String)"No unexpected exceptions", (boolean)exceptions.isEmpty());
    }
}

